/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.catalog.CatalogType;
import org.apache.amoro.server.terminal.TerminalSessionFactory;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class SparkContextUtil {
    public static final String ICEBERG_EXTENSION = "org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions";
    public static final String MIXED_FORMAT_EXTENSION = "org.apache.amoro.spark.MixedFormatSparkExtensions";
    public static final String ICEBERG_CATALOG = "org.apache.iceberg.spark.SparkCatalog";
    public static final String MIXED_FORMAT_CATALOG = "org.apache.amoro.spark.MixedFormatSparkCatalog";
    public static final String PAIMON_CATALOG = "org.apache.paimon.spark.SparkCatalog";
    public static final String MIXED_FORMAT_SESSION_CATALOG = "org.apache.amoro.spark.MixedFormatSparkSessionCatalog";
    public static final String UNIFIED_SESSION_CATALOG = "org.apache.amoro.spark.SparkUnifiedSessionCatalog";
    public static final String UNIFIED_CATALOG = "org.apache.amoro.spark.SparkUnifiedCatalog";
    public static final String MIXED_FORMAT_PROPERTY_REFRESH_BEFORE_USAGE = "spark.sql.mixed-format.refresh-catalog-before-usage";

    public static Map<String, String> getSparkConf(Configurations sessionConfig) {
        LinkedHashMap sparkConf = Maps.newLinkedHashMap();
        sparkConf.put("spark.sql.extensions", "org.apache.amoro.spark.MixedFormatSparkExtensions,org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions");
        List catalogs = (List)sessionConfig.get(TerminalSessionFactory.SessionConfigOptions.CATALOGS);
        String catalogUrlBase = (String)sessionConfig.get(TerminalSessionFactory.SessionConfigOptions.CATALOG_URL_BASE);
        for (String catalog : catalogs) {
            String type;
            String catalogClassName;
            String connector = (String)sessionConfig.get(TerminalSessionFactory.SessionConfigOptions.catalogConnector(catalog));
            String sparkCatalogPrefix = "spark.sql.catalog." + catalog;
            if ("arctic".equalsIgnoreCase(connector) || "mixed_iceberg".equalsIgnoreCase(connector) || "mixed_hive".equalsIgnoreCase(connector)) {
                catalogClassName = MIXED_FORMAT_CATALOG;
                type = (String)sessionConfig.get(TerminalSessionFactory.SessionConfigOptions.catalogProperty(catalog, "type"));
                if (sessionConfig.getBoolean(TerminalSessionFactory.SessionConfigOptions.USING_SESSION_CATALOG_FOR_HIVE) && CatalogType.HIVE.name().equalsIgnoreCase(type)) {
                    sparkCatalogPrefix = "spark.sql.catalog.spark_catalog";
                    catalogClassName = MIXED_FORMAT_SESSION_CATALOG;
                }
                sparkConf.put(sparkCatalogPrefix + ".url", catalogUrlBase + "/" + catalog);
            } else if ("unified".equalsIgnoreCase(connector)) {
                catalogClassName = UNIFIED_CATALOG;
                type = (String)sessionConfig.get(TerminalSessionFactory.SessionConfigOptions.catalogProperty(catalog, "type"));
                if (sessionConfig.getBoolean(TerminalSessionFactory.SessionConfigOptions.USING_SESSION_CATALOG_FOR_HIVE) && CatalogType.HIVE.name().equalsIgnoreCase(type)) {
                    sparkCatalogPrefix = "spark.sql.catalog.spark_catalog";
                    catalogClassName = UNIFIED_SESSION_CATALOG;
                }
                sparkConf.put(sparkCatalogPrefix + ".uri", catalogUrlBase + "/" + catalog);
            } else {
                catalogClassName = "iceberg".equalsIgnoreCase(connector) ? ICEBERG_CATALOG : PAIMON_CATALOG;
                Map<String, String> properties = TerminalSessionFactory.SessionConfigOptions.getCatalogProperties(sessionConfig, catalog);
                for (String key : properties.keySet()) {
                    String property = properties.get(key);
                    sparkConf.put(sparkCatalogPrefix + "." + key, property);
                }
            }
            sparkConf.put(sparkCatalogPrefix, catalogClassName);
        }
        return sparkConf;
    }
}

