/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import java.time.Duration;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BlockerExpiringExecutor;
import org.apache.amoro.server.table.executor.DanglingDeleteFilesCleaningExecutor;
import org.apache.amoro.server.table.executor.DataExpiringExecutor;
import org.apache.amoro.server.table.executor.HiveCommitSyncExecutor;
import org.apache.amoro.server.table.executor.OptimizingCommitExecutor;
import org.apache.amoro.server.table.executor.OptimizingExpiringExecutor;
import org.apache.amoro.server.table.executor.OrphanFilesCleaningExecutor;
import org.apache.amoro.server.table.executor.SnapshotsExpiringExecutor;
import org.apache.amoro.server.table.executor.TableRuntimeRefreshExecutor;
import org.apache.amoro.server.table.executor.TagsAutoCreatingExecutor;

public class AsyncTableExecutors {
    private static final AsyncTableExecutors instance = new AsyncTableExecutors();
    private SnapshotsExpiringExecutor snapshotsExpiringExecutor;
    private TableRuntimeRefreshExecutor tableRefreshingExecutor;
    private OrphanFilesCleaningExecutor orphanFilesCleaningExecutor;
    private DanglingDeleteFilesCleaningExecutor danglingDeleteFilesCleaningExecutor;
    private BlockerExpiringExecutor blockerExpiringExecutor;
    private OptimizingCommitExecutor optimizingCommitExecutor;
    private OptimizingExpiringExecutor optimizingExpiringExecutor;
    private HiveCommitSyncExecutor hiveCommitSyncExecutor;
    private TagsAutoCreatingExecutor tagsAutoCreatingExecutor;
    private DataExpiringExecutor dataExpiringExecutor;

    public static AsyncTableExecutors getInstance() {
        return instance;
    }

    public void setup(TableService tableService, Configurations conf) {
        if (conf.getBoolean(AmoroManagementConf.EXPIRE_SNAPSHOTS_ENABLED)) {
            this.snapshotsExpiringExecutor = new SnapshotsExpiringExecutor(tableService, conf.getInteger(AmoroManagementConf.EXPIRE_SNAPSHOTS_THREAD_COUNT));
        }
        if (conf.getBoolean(AmoroManagementConf.CLEAN_ORPHAN_FILES_ENABLED)) {
            this.orphanFilesCleaningExecutor = new OrphanFilesCleaningExecutor(tableService, conf.getInteger(AmoroManagementConf.CLEAN_ORPHAN_FILES_THREAD_COUNT), (Duration)conf.get(AmoroManagementConf.CLEAN_ORPHAN_FILES_INTERVAL));
        }
        if (conf.getBoolean(AmoroManagementConf.CLEAN_DANGLING_DELETE_FILES_ENABLED)) {
            this.danglingDeleteFilesCleaningExecutor = new DanglingDeleteFilesCleaningExecutor(tableService, conf.getInteger(AmoroManagementConf.CLEAN_DANGLING_DELETE_FILES_THREAD_COUNT));
        }
        this.optimizingCommitExecutor = new OptimizingCommitExecutor(tableService, conf.getInteger(AmoroManagementConf.OPTIMIZING_COMMIT_THREAD_COUNT));
        this.optimizingExpiringExecutor = new OptimizingExpiringExecutor(tableService, conf.getInteger(AmoroManagementConf.OPTIMIZING_RUNTIME_DATA_KEEP_DAYS), conf.getInteger(AmoroManagementConf.OPTIMIZING_RUNTIME_DATA_EXPIRE_INTERVAL_HOURS));
        this.blockerExpiringExecutor = new BlockerExpiringExecutor(tableService);
        if (conf.getBoolean(AmoroManagementConf.SYNC_HIVE_TABLES_ENABLED)) {
            this.hiveCommitSyncExecutor = new HiveCommitSyncExecutor(tableService, conf.getInteger(AmoroManagementConf.SYNC_HIVE_TABLES_THREAD_COUNT));
        }
        this.tableRefreshingExecutor = new TableRuntimeRefreshExecutor(tableService, conf.getInteger(AmoroManagementConf.REFRESH_TABLES_THREAD_COUNT), ((Duration)conf.get(AmoroManagementConf.REFRESH_TABLES_INTERVAL)).toMillis(), conf.getInteger(AmoroManagementConf.REFRESH_MAX_PENDING_PARTITIONS));
        if (conf.getBoolean(AmoroManagementConf.AUTO_CREATE_TAGS_ENABLED)) {
            this.tagsAutoCreatingExecutor = new TagsAutoCreatingExecutor(tableService, conf.getInteger(AmoroManagementConf.AUTO_CREATE_TAGS_THREAD_COUNT), ((Duration)conf.get(AmoroManagementConf.AUTO_CREATE_TAGS_INTERVAL)).toMillis());
        }
        if (conf.getBoolean(AmoroManagementConf.DATA_EXPIRATION_ENABLED)) {
            this.dataExpiringExecutor = new DataExpiringExecutor(tableService, conf.getInteger(AmoroManagementConf.DATA_EXPIRATION_THREAD_COUNT), (Duration)conf.get(AmoroManagementConf.DATA_EXPIRATION_INTERVAL));
        }
    }

    public SnapshotsExpiringExecutor getSnapshotsExpiringExecutor() {
        return this.snapshotsExpiringExecutor;
    }

    public TableRuntimeRefreshExecutor getTableRefreshingExecutor() {
        return this.tableRefreshingExecutor;
    }

    public OrphanFilesCleaningExecutor getOrphanFilesCleaningExecutor() {
        return this.orphanFilesCleaningExecutor;
    }

    public DanglingDeleteFilesCleaningExecutor getDanglingDeleteFilesCleaningExecutor() {
        return this.danglingDeleteFilesCleaningExecutor;
    }

    public BlockerExpiringExecutor getBlockerExpiringExecutor() {
        return this.blockerExpiringExecutor;
    }

    public OptimizingCommitExecutor getOptimizingCommitExecutor() {
        return this.optimizingCommitExecutor;
    }

    public OptimizingExpiringExecutor getOptimizingExpiringExecutor() {
        return this.optimizingExpiringExecutor;
    }

    public HiveCommitSyncExecutor getHiveCommitSyncExecutor() {
        return this.hiveCommitSyncExecutor;
    }

    public TagsAutoCreatingExecutor getTagsAutoCreatingExecutor() {
        return this.tagsAutoCreatingExecutor;
    }

    public DataExpiringExecutor getDataExpiringExecutor() {
        return this.dataExpiringExecutor;
    }
}

