/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.server.dashboard.OverviewManager;
import org.apache.amoro.server.dashboard.model.OverviewDataSizeItem;
import org.apache.amoro.server.dashboard.model.OverviewResourceUsageItem;
import org.apache.amoro.server.dashboard.model.OverviewSummary;
import org.apache.amoro.server.dashboard.model.OverviewTopTableItem;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;

public class OverviewController {
    private final OverviewManager manager;

    public OverviewController(OverviewManager manager) {
        this.manager = manager;
    }

    public void getResourceUsageHistory(Context ctx) {
        String startTime = ctx.queryParam("startTime");
        Preconditions.checkArgument((boolean)StringUtils.isNumeric((CharSequence)startTime), (Object)"invalid startTime!");
        List<OverviewResourceUsageItem> resourceUsageHistory = this.manager.getResourceUsageHistory(Long.parseLong(startTime));
        ctx.json(OkResponse.of(resourceUsageHistory));
    }

    public void getDataSizeHistory(Context ctx) {
        String startTime = ctx.queryParam("startTime");
        Preconditions.checkArgument((boolean)StringUtils.isNumeric((CharSequence)startTime), (Object)"invalid startTime!");
        List<OverviewDataSizeItem> dataSizeHistory = this.manager.getDataSizeHistory(Long.parseLong(startTime));
        ctx.json(OkResponse.of(dataSizeHistory));
    }

    public void getTopTables(Context ctx) {
        List<OverviewTopTableItem> top10Tables;
        String order = ctx.queryParam("order");
        String orderBy = ctx.queryParam("orderBy");
        Integer limit = (Integer)ctx.queryParamAsClass("limit", Integer.class).getOrDefault((Object)10);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)order), (Object)"order can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderBy), (Object)"orderBy can not be empty");
        boolean isAsc = "asc".equals(order);
        switch (orderBy) {
            case "tableSize": {
                Comparator<OverviewTopTableItem> tableSizeComparator = Comparator.comparingLong(OverviewTopTableItem::getTableSize);
                top10Tables = this.getTopTables(isAsc, tableSizeComparator, limit);
                break;
            }
            case "fileCount": {
                Comparator<OverviewTopTableItem> fileCountComparator = Comparator.comparingLong(OverviewTopTableItem::getFileCount);
                top10Tables = this.getTopTables(isAsc, fileCountComparator, limit);
                break;
            }
            case "healthScore": {
                Comparator<OverviewTopTableItem> healthScoreComparator = Comparator.comparingLong(item -> item.getHealthScore() < 0 ? (isAsc ? Long.MAX_VALUE : Long.MIN_VALUE) : (long)item.getHealthScore());
                top10Tables = this.getTopTables(isAsc, healthScoreComparator, limit);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orderBy: " + orderBy);
            }
        }
        ctx.json(OkResponse.of(top10Tables));
    }

    private List<OverviewTopTableItem> getTopTables(boolean asc, Comparator<OverviewTopTableItem> comparator, int limit) {
        return this.manager.getAllTopTableItem().stream().sorted(asc ? comparator.thenComparing(OverviewTopTableItem::getTableName) : comparator.reversed().thenComparing(OverviewTopTableItem::getTableName)).limit(limit).collect(Collectors.toList());
    }

    public void getSummary(Context ctx) {
        int totalCatalog = this.manager.getTotalCatalog();
        int totalTableCount = this.manager.getTotalTableCount();
        long totalDataSize = this.manager.getTotalDataSize();
        int totalCpu = this.manager.getTotalCpu();
        long totalMemory = this.manager.getTotalMemory();
        OverviewSummary overviewSummary = new OverviewSummary(totalCatalog, totalTableCount, totalDataSize, totalCpu, totalMemory);
        ctx.json(OkResponse.of(overviewSummary));
    }

    public void getOptimizingStatus(Context ctx) {
        Map<String, Long> optimizingStatus = this.manager.getOptimizingStatus();
        List optimizingStatusList = optimizingStatus.entrySet().stream().map(status -> ImmutableMap.of((Object)"name", status.getKey(), (Object)"value", status.getValue())).collect(Collectors.toList());
        ctx.json(OkResponse.of(optimizingStatusList));
    }
}

