/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGraphTranslator
implements FlinkPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraphTranslator.class);
    private final ClassLoader userClassloader;

    public StreamGraphTranslator(ClassLoader userClassloader) {
        this.userClassloader = userClassloader;
    }

    @Override
    public JobGraph translateToJobGraph(Pipeline pipeline, Configuration optimizerConfiguration, int defaultParallelism) {
        Preconditions.checkArgument((boolean)(pipeline instanceof StreamGraph), (Object)"Given pipeline is not a DataStream StreamGraph.");
        StreamGraph streamGraph = (StreamGraph)pipeline;
        return streamGraph.getJobGraph(this.userClassloader, null);
    }

    @Override
    public String translateToJSONExecutionPlan(Pipeline pipeline) {
        Preconditions.checkArgument((boolean)(pipeline instanceof StreamGraph), (Object)"Given pipeline is not a DataStream StreamGraph.");
        StreamGraph streamGraph = (StreamGraph)pipeline;
        return streamGraph.getStreamingPlanAsJSON();
    }

    @Override
    public boolean canTranslate(Pipeline pipeline) {
        return pipeline instanceof StreamGraph;
    }
}

