/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.ColumnListCopier;
import software.amazon.awssdk.services.glue.model.LocationStringListCopier;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.services.glue.model.Order;
import software.amazon.awssdk.services.glue.model.OrderListCopier;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.SchemaReference;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.SkewedInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageDescriptor> {
    private static final SdkField<List<Column>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Columns").getter(StorageDescriptor.getter(StorageDescriptor::columns)).setter(StorageDescriptor.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(StorageDescriptor.getter(StorageDescriptor::location)).setter(StorageDescriptor.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalLocations").getter(StorageDescriptor.getter(StorageDescriptor::additionalLocations)).setter(StorageDescriptor.setter(Builder::additionalLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFormat").getter(StorageDescriptor.getter(StorageDescriptor::inputFormat)).setter(StorageDescriptor.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(StorageDescriptor.getter(StorageDescriptor::outputFormat)).setter(StorageDescriptor.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<Boolean> COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Compressed").getter(StorageDescriptor.getter(StorageDescriptor::compressed)).setter(StorageDescriptor.setter(Builder::compressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compressed").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBuckets").getter(StorageDescriptor.getter(StorageDescriptor::numberOfBuckets)).setter(StorageDescriptor.setter(Builder::numberOfBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBuckets").build()}).build();
    private static final SdkField<SerDeInfo> SERDE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SerdeInfo").getter(StorageDescriptor.getter(StorageDescriptor::serdeInfo)).setter(StorageDescriptor.setter(Builder::serdeInfo)).constructor(SerDeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerdeInfo").build()}).build();
    private static final SdkField<List<String>> BUCKET_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BucketColumns").getter(StorageDescriptor.getter(StorageDescriptor::bucketColumns)).setter(StorageDescriptor.setter(Builder::bucketColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Order>> SORT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortColumns").getter(StorageDescriptor.getter(StorageDescriptor::sortColumns)).setter(StorageDescriptor.setter(Builder::sortColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Order::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(StorageDescriptor.getter(StorageDescriptor::parameters)).setter(StorageDescriptor.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SkewedInfo> SKEWED_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SkewedInfo").getter(StorageDescriptor.getter(StorageDescriptor::skewedInfo)).setter(StorageDescriptor.setter(Builder::skewedInfo)).constructor(SkewedInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedInfo").build()}).build();
    private static final SdkField<Boolean> STORED_AS_SUB_DIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StoredAsSubDirectories").getter(StorageDescriptor.getter(StorageDescriptor::storedAsSubDirectories)).setter(StorageDescriptor.setter(Builder::storedAsSubDirectories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredAsSubDirectories").build()}).build();
    private static final SdkField<SchemaReference> SCHEMA_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaReference").getter(StorageDescriptor.getter(StorageDescriptor::schemaReference)).setter(StorageDescriptor.setter(Builder::schemaReference)).constructor(SchemaReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD, LOCATION_FIELD, ADDITIONAL_LOCATIONS_FIELD, INPUT_FORMAT_FIELD, OUTPUT_FORMAT_FIELD, COMPRESSED_FIELD, NUMBER_OF_BUCKETS_FIELD, SERDE_INFO_FIELD, BUCKET_COLUMNS_FIELD, SORT_COLUMNS_FIELD, PARAMETERS_FIELD, SKEWED_INFO_FIELD, STORED_AS_SUB_DIRECTORIES_FIELD, SCHEMA_REFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Column> columns;
    private final String location;
    private final List<String> additionalLocations;
    private final String inputFormat;
    private final String outputFormat;
    private final Boolean compressed;
    private final Integer numberOfBuckets;
    private final SerDeInfo serdeInfo;
    private final List<String> bucketColumns;
    private final List<Order> sortColumns;
    private final Map<String, String> parameters;
    private final SkewedInfo skewedInfo;
    private final Boolean storedAsSubDirectories;
    private final SchemaReference schemaReference;

    private StorageDescriptor(BuilderImpl builder) {
        this.columns = builder.columns;
        this.location = builder.location;
        this.additionalLocations = builder.additionalLocations;
        this.inputFormat = builder.inputFormat;
        this.outputFormat = builder.outputFormat;
        this.compressed = builder.compressed;
        this.numberOfBuckets = builder.numberOfBuckets;
        this.serdeInfo = builder.serdeInfo;
        this.bucketColumns = builder.bucketColumns;
        this.sortColumns = builder.sortColumns;
        this.parameters = builder.parameters;
        this.skewedInfo = builder.skewedInfo;
        this.storedAsSubDirectories = builder.storedAsSubDirectories;
        this.schemaReference = builder.schemaReference;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<Column> columns() {
        return this.columns;
    }

    public final String location() {
        return this.location;
    }

    public final boolean hasAdditionalLocations() {
        return this.additionalLocations != null && !(this.additionalLocations instanceof SdkAutoConstructList);
    }

    public final List<String> additionalLocations() {
        return this.additionalLocations;
    }

    public final String inputFormat() {
        return this.inputFormat;
    }

    public final String outputFormat() {
        return this.outputFormat;
    }

    public final Boolean compressed() {
        return this.compressed;
    }

    public final Integer numberOfBuckets() {
        return this.numberOfBuckets;
    }

    public final SerDeInfo serdeInfo() {
        return this.serdeInfo;
    }

    public final boolean hasBucketColumns() {
        return this.bucketColumns != null && !(this.bucketColumns instanceof SdkAutoConstructList);
    }

    public final List<String> bucketColumns() {
        return this.bucketColumns;
    }

    public final boolean hasSortColumns() {
        return this.sortColumns != null && !(this.sortColumns instanceof SdkAutoConstructList);
    }

    public final List<Order> sortColumns() {
        return this.sortColumns;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final SkewedInfo skewedInfo() {
        return this.skewedInfo;
    }

    public final Boolean storedAsSubDirectories() {
        return this.storedAsSubDirectories;
    }

    public final SchemaReference schemaReference() {
        return this.schemaReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalLocations() ? this.additionalLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(this.serdeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBucketColumns() ? this.bucketColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortColumns() ? this.sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.skewedInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.storedAsSubDirectories());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageDescriptor)) {
            return false;
        }
        StorageDescriptor other = (StorageDescriptor)obj;
        return this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && Objects.equals(this.location(), other.location()) && this.hasAdditionalLocations() == other.hasAdditionalLocations() && Objects.equals(this.additionalLocations(), other.additionalLocations()) && Objects.equals(this.inputFormat(), other.inputFormat()) && Objects.equals(this.outputFormat(), other.outputFormat()) && Objects.equals(this.compressed(), other.compressed()) && Objects.equals(this.numberOfBuckets(), other.numberOfBuckets()) && Objects.equals(this.serdeInfo(), other.serdeInfo()) && this.hasBucketColumns() == other.hasBucketColumns() && Objects.equals(this.bucketColumns(), other.bucketColumns()) && this.hasSortColumns() == other.hasSortColumns() && Objects.equals(this.sortColumns(), other.sortColumns()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.skewedInfo(), other.skewedInfo()) && Objects.equals(this.storedAsSubDirectories(), other.storedAsSubDirectories()) && Objects.equals(this.schemaReference(), other.schemaReference());
    }

    public final String toString() {
        return ToString.builder((String)"StorageDescriptor").add("Columns", this.hasColumns() ? this.columns() : null).add("Location", (Object)this.location()).add("AdditionalLocations", this.hasAdditionalLocations() ? this.additionalLocations() : null).add("InputFormat", (Object)this.inputFormat()).add("OutputFormat", (Object)this.outputFormat()).add("Compressed", (Object)this.compressed()).add("NumberOfBuckets", (Object)this.numberOfBuckets()).add("SerdeInfo", (Object)this.serdeInfo()).add("BucketColumns", this.hasBucketColumns() ? this.bucketColumns() : null).add("SortColumns", this.hasSortColumns() ? this.sortColumns() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).add("SkewedInfo", (Object)this.skewedInfo()).add("StoredAsSubDirectories", (Object)this.storedAsSubDirectories()).add("SchemaReference", (Object)this.schemaReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "AdditionalLocations": {
                return Optional.ofNullable(clazz.cast(this.additionalLocations()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormat()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormat()));
            }
            case "Compressed": {
                return Optional.ofNullable(clazz.cast(this.compressed()));
            }
            case "NumberOfBuckets": {
                return Optional.ofNullable(clazz.cast(this.numberOfBuckets()));
            }
            case "SerdeInfo": {
                return Optional.ofNullable(clazz.cast(this.serdeInfo()));
            }
            case "BucketColumns": {
                return Optional.ofNullable(clazz.cast(this.bucketColumns()));
            }
            case "SortColumns": {
                return Optional.ofNullable(clazz.cast(this.sortColumns()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "SkewedInfo": {
                return Optional.ofNullable(clazz.cast(this.skewedInfo()));
            }
            case "StoredAsSubDirectories": {
                return Optional.ofNullable(clazz.cast(this.storedAsSubDirectories()));
            }
            case "SchemaReference": {
                return Optional.ofNullable(clazz.cast(this.schemaReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageDescriptor, T> g) {
        return obj -> g.apply((StorageDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Column> columns = DefaultSdkAutoConstructList.getInstance();
        private String location;
        private List<String> additionalLocations = DefaultSdkAutoConstructList.getInstance();
        private String inputFormat;
        private String outputFormat;
        private Boolean compressed;
        private Integer numberOfBuckets;
        private SerDeInfo serdeInfo;
        private List<String> bucketColumns = DefaultSdkAutoConstructList.getInstance();
        private List<Order> sortColumns = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private SkewedInfo skewedInfo;
        private Boolean storedAsSubDirectories;
        private SchemaReference schemaReference;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageDescriptor model) {
            this.columns(model.columns);
            this.location(model.location);
            this.additionalLocations(model.additionalLocations);
            this.inputFormat(model.inputFormat);
            this.outputFormat(model.outputFormat);
            this.compressed(model.compressed);
            this.numberOfBuckets(model.numberOfBuckets);
            this.serdeInfo(model.serdeInfo);
            this.bucketColumns(model.bucketColumns);
            this.sortColumns(model.sortColumns);
            this.parameters(model.parameters);
            this.skewedInfo(model.skewedInfo);
            this.storedAsSubDirectories(model.storedAsSubDirectories);
            this.schemaReference(model.schemaReference);
        }

        public final List<Column.Builder> getColumns() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<Column.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<Column> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Column ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<Column.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Collection<String> getAdditionalLocations() {
            if (this.additionalLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalLocations;
        }

        public final void setAdditionalLocations(Collection<String> additionalLocations) {
            this.additionalLocations = LocationStringListCopier.copy(additionalLocations);
        }

        @Override
        public final Builder additionalLocations(Collection<String> additionalLocations) {
            this.additionalLocations = LocationStringListCopier.copy(additionalLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLocations(String ... additionalLocations) {
            this.additionalLocations(Arrays.asList(additionalLocations));
            return this;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public final Boolean getCompressed() {
            return this.compressed;
        }

        public final void setCompressed(Boolean compressed) {
            this.compressed = compressed;
        }

        @Override
        public final Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public final Integer getNumberOfBuckets() {
            return this.numberOfBuckets;
        }

        public final void setNumberOfBuckets(Integer numberOfBuckets) {
            this.numberOfBuckets = numberOfBuckets;
        }

        @Override
        public final Builder numberOfBuckets(Integer numberOfBuckets) {
            this.numberOfBuckets = numberOfBuckets;
            return this;
        }

        public final SerDeInfo.Builder getSerdeInfo() {
            return this.serdeInfo != null ? this.serdeInfo.toBuilder() : null;
        }

        public final void setSerdeInfo(SerDeInfo.BuilderImpl serdeInfo) {
            this.serdeInfo = serdeInfo != null ? serdeInfo.build() : null;
        }

        @Override
        public final Builder serdeInfo(SerDeInfo serdeInfo) {
            this.serdeInfo = serdeInfo;
            return this;
        }

        public final Collection<String> getBucketColumns() {
            if (this.bucketColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bucketColumns;
        }

        public final void setBucketColumns(Collection<String> bucketColumns) {
            this.bucketColumns = NameStringListCopier.copy(bucketColumns);
        }

        @Override
        public final Builder bucketColumns(Collection<String> bucketColumns) {
            this.bucketColumns = NameStringListCopier.copy(bucketColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketColumns(String ... bucketColumns) {
            this.bucketColumns(Arrays.asList(bucketColumns));
            return this;
        }

        public final List<Order.Builder> getSortColumns() {
            List<Order.Builder> result = OrderListCopier.copyToBuilder(this.sortColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortColumns(Collection<Order.BuilderImpl> sortColumns) {
            this.sortColumns = OrderListCopier.copyFromBuilder(sortColumns);
        }

        @Override
        public final Builder sortColumns(Collection<Order> sortColumns) {
            this.sortColumns = OrderListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(Order ... sortColumns) {
            this.sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(Consumer<Order.Builder> ... sortColumns) {
            this.sortColumns(Stream.of(sortColumns).map(c -> (Order)((Order.Builder)Order.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final SkewedInfo.Builder getSkewedInfo() {
            return this.skewedInfo != null ? this.skewedInfo.toBuilder() : null;
        }

        public final void setSkewedInfo(SkewedInfo.BuilderImpl skewedInfo) {
            this.skewedInfo = skewedInfo != null ? skewedInfo.build() : null;
        }

        @Override
        public final Builder skewedInfo(SkewedInfo skewedInfo) {
            this.skewedInfo = skewedInfo;
            return this;
        }

        public final Boolean getStoredAsSubDirectories() {
            return this.storedAsSubDirectories;
        }

        public final void setStoredAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
        }

        @Override
        public final Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        public final SchemaReference.Builder getSchemaReference() {
            return this.schemaReference != null ? this.schemaReference.toBuilder() : null;
        }

        public final void setSchemaReference(SchemaReference.BuilderImpl schemaReference) {
            this.schemaReference = schemaReference != null ? schemaReference.build() : null;
        }

        @Override
        public final Builder schemaReference(SchemaReference schemaReference) {
            this.schemaReference = schemaReference;
            return this;
        }

        public StorageDescriptor build() {
            return new StorageDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageDescriptor> {
        public Builder columns(Collection<Column> var1);

        public Builder columns(Column ... var1);

        public Builder columns(Consumer<Column.Builder> ... var1);

        public Builder location(String var1);

        public Builder additionalLocations(Collection<String> var1);

        public Builder additionalLocations(String ... var1);

        public Builder inputFormat(String var1);

        public Builder outputFormat(String var1);

        public Builder compressed(Boolean var1);

        public Builder numberOfBuckets(Integer var1);

        public Builder serdeInfo(SerDeInfo var1);

        default public Builder serdeInfo(Consumer<SerDeInfo.Builder> serdeInfo) {
            return this.serdeInfo((SerDeInfo)((SerDeInfo.Builder)SerDeInfo.builder().applyMutation(serdeInfo)).build());
        }

        public Builder bucketColumns(Collection<String> var1);

        public Builder bucketColumns(String ... var1);

        public Builder sortColumns(Collection<Order> var1);

        public Builder sortColumns(Order ... var1);

        public Builder sortColumns(Consumer<Order.Builder> ... var1);

        public Builder parameters(Map<String, String> var1);

        public Builder skewedInfo(SkewedInfo var1);

        default public Builder skewedInfo(Consumer<SkewedInfo.Builder> skewedInfo) {
            return this.skewedInfo((SkewedInfo)((SkewedInfo.Builder)SkewedInfo.builder().applyMutation(skewedInfo)).build());
        }

        public Builder storedAsSubDirectories(Boolean var1);

        public Builder schemaReference(SchemaReference var1);

        default public Builder schemaReference(Consumer<SchemaReference.Builder> schemaReference) {
            return this.schemaReference((SchemaReference)((SchemaReference.Builder)SchemaReference.builder().applyMutation(schemaReference)).build());
        }
    }
}

