/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(WatermarkGenerator.class);
    public static final String INGEST_TIME = "_ingest_time";
    public static final String EVENT_TIME_TIMESTAMP_MS = "TIMESTAMP_MS";
    public static final String EVENT_TIME_TIMESTAMP_S = "TIMESTAMP_S";
    private static final Types.NestedField INGEST_TIME_FIELD = Types.NestedField.required((int)2147481647, (String)"_ingest_time", (Type)Types.LongType.get(), (String)"virtual ingest time field ");
    private long watermark = -1L;
    private final Types.NestedField eventTimeField;
    private final long lateness;
    private final SimpleDateFormat eventTimeStringFormat;
    private final String eventTimeNumberFormat;

    public static WatermarkGenerator forTable(MixedTable table) {
        Types.NestedField eventTimeField = INGEST_TIME_FIELD;
        String eventTimeName = table.properties().getOrDefault("table.event-time-field", INGEST_TIME);
        if (!eventTimeName.equals(INGEST_TIME) && (eventTimeField = table.schema().findField(eventTimeName)) == null) {
            throw new IllegalStateException("Unknown event time field " + eventTimeName + " in table " + table.id());
        }
        long lateness = PropertyUtil.propertyAsLong(table.properties(), (String)"table.watermark-allowed-lateness-second", (long)0L) * 1000L;
        return new WatermarkGenerator(eventTimeField, lateness, table.properties().getOrDefault("table.event-time-field.datetime-string-format", "yyyy-MM-dd HH:mm:ss"), table.properties().getOrDefault("table.event-time-field.datetime-number-format", EVENT_TIME_TIMESTAMP_MS));
    }

    private WatermarkGenerator(Types.NestedField eventTimeField, long lateness, String eventTimeStringFormat, String eventTimeNumberFormat) {
        this.eventTimeField = eventTimeField;
        this.lateness = lateness;
        this.eventTimeStringFormat = new SimpleDateFormat(eventTimeStringFormat);
        this.eventTimeNumberFormat = eventTimeNumberFormat;
    }

    public long watermark() {
        return this.watermark;
    }

    public <F> void addFile(ContentFile<F> file) {
        try {
            Map upperBounds = file.upperBounds();
            if (upperBounds != null && upperBounds.containsKey(this.eventTimeField.fieldId())) {
                ByteBuffer byteBuffer = (ByteBuffer)upperBounds.get(this.eventTimeField.fieldId());
                long maxEventTime = -1L;
                switch (this.eventTimeField.type().typeId()) {
                    case INTEGER: {
                        Integer eventTimeIntegerValue = (Integer)Conversions.fromByteBuffer((Type)this.eventTimeField.type(), (ByteBuffer)byteBuffer);
                        maxEventTime = this.eventTimeFromInteger(eventTimeIntegerValue);
                        break;
                    }
                    case LONG: {
                        Long eventTimeLongValue = (Long)Conversions.fromByteBuffer((Type)this.eventTimeField.type(), (ByteBuffer)byteBuffer);
                        maxEventTime = this.eventTimeFromLong(eventTimeLongValue);
                        break;
                    }
                    case DECIMAL: {
                        BigDecimal eventTimeDecimalValue = (BigDecimal)Conversions.fromByteBuffer((Type)this.eventTimeField.type(), (ByteBuffer)byteBuffer);
                        maxEventTime = this.eventTimeFromDecimal(eventTimeDecimalValue);
                        break;
                    }
                    case TIMESTAMP: {
                        Long eventTimeTimestampValue = (Long)Conversions.fromByteBuffer((Type)this.eventTimeField.type(), (ByteBuffer)byteBuffer);
                        maxEventTime = this.eventTimeFromTimestamp(eventTimeTimestampValue);
                        break;
                    }
                    case STRING: {
                        String eventTimeStringValue = Conversions.fromByteBuffer((Type)this.eventTimeField.type(), (ByteBuffer)byteBuffer).toString();
                        maxEventTime = this.eventTimeFromString(eventTimeStringValue);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported event time type:" + this.eventTimeField.type());
                    }
                }
                long watermark = maxEventTime - this.lateness;
                this.watermark = Math.max(watermark, this.watermark);
            } else if (this.eventTimeField.equals((Object)INGEST_TIME_FIELD)) {
                long watermark = System.currentTimeMillis() - this.lateness;
                this.watermark = Math.max(watermark, this.watermark);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to calculate watermark from date file", (Throwable)e);
        }
    }

    private long eventTimeFromInteger(Integer integerValue) {
        if (this.eventTimeNumberFormat.equals(EVENT_TIME_TIMESTAMP_S)) {
            return integerValue * 1000;
        }
        throw new IllegalArgumentException("Illegal datetime number format " + this.eventTimeNumberFormat + " for int type");
    }

    private long eventTimeFromLong(Long longValue) {
        if (this.eventTimeNumberFormat.equals(EVENT_TIME_TIMESTAMP_S)) {
            return longValue * 1000L;
        }
        if (this.eventTimeNumberFormat.equals(EVENT_TIME_TIMESTAMP_MS)) {
            return longValue;
        }
        throw new IllegalArgumentException("Illegal datetime number format " + this.eventTimeNumberFormat + " for long type");
    }

    private long eventTimeFromDecimal(BigDecimal decimalValue) {
        if (this.eventTimeNumberFormat.equals(EVENT_TIME_TIMESTAMP_S)) {
            return decimalValue.longValue() * 1000L;
        }
        if (this.eventTimeNumberFormat.equals(EVENT_TIME_TIMESTAMP_MS)) {
            return decimalValue.longValue();
        }
        throw new IllegalArgumentException("Illegal datetime number format " + this.eventTimeNumberFormat + " for decimal type");
    }

    private long eventTimeFromTimestamp(Long longValue) {
        return longValue;
    }

    private long eventTimeFromString(String stringValue) {
        try {
            return this.eventTimeStringFormat.parse(stringValue).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Fail to parse event time for string value:" + stringValue + ", with format: " + this.eventTimeStringFormat.toPattern());
        }
    }
}

