/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.log;

import java.io.Serializable;
import org.apache.amoro.log.LogData;
import org.apache.amoro.log.LogDataToJsonConverters;
import org.apache.amoro.log.MessageBytes;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;

public class LogDataJsonSerialization<T>
implements Serializable {
    private static final long serialVersionUID = 66420071549145794L;
    private transient LogDataToJsonConverters.LogDataToJsonConverter<T> logDataToJsonConverter;
    private final Schema schema;
    private final LogData.FieldGetterFactory<T> fieldGetterFactory;
    private transient ObjectNode node;
    private final ObjectMapper mapper = new ObjectMapper();
    private transient LogDataToJsonConverters.LogDataToJsonConverter.FormatConverterContext converterContext;

    public LogDataJsonSerialization(Schema schema, LogData.FieldGetterFactory<T> fieldGetterFactory) {
        this.schema = schema;
        this.fieldGetterFactory = fieldGetterFactory;
    }

    public void init() {
        if (this.logDataToJsonConverter == null) {
            this.logDataToJsonConverter = LogDataToJsonConverters.createConverter((Type)this.schema.asStruct(), this.fieldGetterFactory);
        }
    }

    public byte[] serialize(LogData<T> element) {
        MessageBytes messageBytes = new MessageBytes();
        messageBytes.append(element.getVersionBytes()).append(element.getUpstreamIdBytes()).append(element.getEpicNoBytes()).append(element.getFlipByte()).append(element.getChangeActionByte());
        if (element.getFlip()) {
            return messageBytes.toBytes();
        }
        if (this.node == null) {
            this.node = this.mapper.createObjectNode();
            this.converterContext = new LogDataToJsonConverters.LogDataToJsonConverter.FormatConverterContext(this.mapper, (JsonNode)this.node);
        }
        try {
            this.convertRow(element);
            byte[] actualDataBytes = this.mapper.writeValueAsBytes((Object)this.node);
            messageBytes.append(actualDataBytes);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + element + "'. ", t);
        }
        return messageBytes.toBytes();
    }

    void convertRow(LogData<T> element) {
        this.init();
        this.logDataToJsonConverter.convert(element.getActualValue(), this.converterContext);
    }
}

