/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.ProcedureInput;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class AncestorsOfProcedure
extends BaseProcedure {
    private static final ProcedureParameter TABLE_PARAM = ProcedureParameter.required("table", DataTypes.StringType);
    private static final ProcedureParameter SNAPSHOT_ID_PARAM = ProcedureParameter.optional("snapshot_id", DataTypes.LongType);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{TABLE_PARAM, SNAPSHOT_ID_PARAM};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("snapshot_id", DataTypes.LongType, true, Metadata.empty()), new StructField("timestamp", DataTypes.LongType, true, Metadata.empty())});

    private AncestorsOfProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<AncestorsOfProcedure>(){

            @Override
            protected AncestorsOfProcedure doBuild() {
                return new AncestorsOfProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        ProcedureInput input = new ProcedureInput(this.spark(), this.tableCatalog(), PARAMETERS, args);
        Identifier tableIdent = input.ident(TABLE_PARAM);
        Long toSnapshotId = input.asLong(SNAPSHOT_ID_PARAM, null);
        SparkTable sparkTable = this.loadSparkTable(tableIdent);
        Table icebergTable = sparkTable.table();
        if (toSnapshotId == null) {
            toSnapshotId = icebergTable.currentSnapshot() != null ? icebergTable.currentSnapshot().snapshotId() : -1L;
        }
        ArrayList snapshotIds = Lists.newArrayList((Iterable)SnapshotUtil.ancestorIdsBetween((long)toSnapshotId, null, arg_0 -> ((Table)icebergTable).snapshot(arg_0)));
        return this.toOutputRow(icebergTable, snapshotIds);
    }

    @Override
    public String description() {
        return "AncestorsOf";
    }

    private InternalRow[] toOutputRow(Table table, List<Long> snapshotIds) {
        if (snapshotIds.isEmpty()) {
            return new InternalRow[0];
        }
        InternalRow[] internalRows = new InternalRow[snapshotIds.size()];
        for (int i = 0; i < snapshotIds.size(); ++i) {
            Long snapshotId = snapshotIds.get(i);
            internalRows[i] = this.newInternalRow(snapshotId, table.snapshot(snapshotId.longValue()).timestampMillis());
        }
        return internalRows;
    }
}

