/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import org.apache.iceberg.spark.functions.UnaryUnboundFunction;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.TimestampType;

public class MonthsFunction
extends UnaryUnboundFunction {
    @Override
    protected BoundFunction doBind(DataType valueType) {
        if (valueType instanceof DateType) {
            return new DateToMonthsFunction();
        }
        if (valueType instanceof TimestampType) {
            return new TimestampToMonthsFunction();
        }
        throw new UnsupportedOperationException("Expected value to be date or timestamp: " + valueType.catalogString());
    }

    public String description() {
        return this.name() + "(col) - Call Iceberg's month transform\n  col :: source column (must be date or timestamp)";
    }

    public String name() {
        return "months";
    }

    public static class TimestampToMonthsFunction
    extends BaseToMonthsFunction {
        public static int invoke(long micros) {
            return DateTimeUtil.microsToMonths((long)micros);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.TimestampType};
        }

        public String canonicalName() {
            return "iceberg.months(timestamp)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(TimestampToMonthsFunction.invoke(input.getLong(0)));
        }
    }

    public static class DateToMonthsFunction
    extends BaseToMonthsFunction {
        public static int invoke(int days) {
            return DateTimeUtil.daysToMonths((int)days);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.DateType};
        }

        public String canonicalName() {
            return "iceberg.months(date)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(DateToMonthsFunction.invoke(input.getInt(0)));
        }
    }

    private static abstract class BaseToMonthsFunction
    implements ScalarFunction<Integer> {
        private BaseToMonthsFunction() {
        }

        public String name() {
            return "months";
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }
    }
}

