/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.ChangelogIterator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.StructType;

public class ComputeUpdateIterator
extends ChangelogIterator {
    private final String[] identifierFields;
    private final List<Integer> identifierFieldIdx;
    private Row cachedRow = null;

    ComputeUpdateIterator(Iterator<Row> rowIterator, StructType rowType, String[] identifierFields) {
        super(rowIterator, rowType);
        this.identifierFieldIdx = Arrays.stream(identifierFields).map(arg_0 -> ((StructType)rowType).fieldIndex(arg_0)).collect(Collectors.toList());
        this.identifierFields = identifierFields;
    }

    @Override
    public boolean hasNext() {
        if (this.cachedRow != null) {
            return true;
        }
        return this.rowIterator().hasNext();
    }

    @Override
    public Row next() {
        if (this.cachedUpdateRecord()) {
            Row row = this.cachedRow;
            this.cachedRow = null;
            return row;
        }
        Row currentRow = this.currentRow();
        if (this.changeType(currentRow).equals(DELETE) && this.rowIterator().hasNext()) {
            Row nextRow;
            this.cachedRow = nextRow = this.rowIterator().next();
            if (this.sameLogicalRow(currentRow, nextRow)) {
                Preconditions.checkState((boolean)this.changeType(nextRow).equals(INSERT), (String)"Cannot compute updates because there are multiple rows with the same identifier fields([%s]). Please make sure the rows are unique.", (Object)String.join((CharSequence)",", this.identifierFields));
                currentRow = this.modify(currentRow, this.changeTypeIndex(), UPDATE_BEFORE);
                this.cachedRow = this.modify(nextRow, this.changeTypeIndex(), UPDATE_AFTER);
            }
        }
        return currentRow;
    }

    private Row modify(Row row, int valueIndex, Object value) {
        if (row instanceof GenericRow) {
            GenericRow genericRow = (GenericRow)row;
            genericRow.values()[valueIndex] = value;
            return genericRow;
        }
        Object[] values = new Object[row.size()];
        for (int index = 0; index < row.size(); ++index) {
            values[index] = row.get(index);
        }
        values[valueIndex] = value;
        return RowFactory.create((Object[])values);
    }

    private boolean cachedUpdateRecord() {
        return this.cachedRow != null && this.changeType(this.cachedRow).equals(UPDATE_AFTER);
    }

    private Row currentRow() {
        if (this.cachedRow != null) {
            Row row = this.cachedRow;
            this.cachedRow = null;
            return row;
        }
        return this.rowIterator().next();
    }

    private boolean sameLogicalRow(Row currentRow, Row nextRow) {
        for (int idx : this.identifierFieldIdx) {
            if (!this.isDifferentValue(currentRow, nextRow, idx)) continue;
            return false;
        }
        return true;
    }
}

