/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.sql.catalyst.util.SQLOrderingUtil$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Some;
import scala.math.Fractional;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;

public final class FloatExactNumeric$
implements Numeric.FloatIsFractional {
    public static FloatExactNumeric$ MODULE$;
    private final int intUpperBound;
    private final int intLowerBound;
    private final long longUpperBound;
    private final long longLowerBound;

    static {
        new FloatExactNumeric$();
    }

    public float div(float x, float y) {
        return Numeric.FloatIsFractional.div$((Numeric.FloatIsFractional)this, (float)x, (float)y);
    }

    public Fractional.FractionalOps mkNumericOps(Object lhs) {
        return Fractional.mkNumericOps$((Fractional)this, (Object)lhs);
    }

    public float plus(float x, float y) {
        return Numeric.FloatIsConflicted.plus$((Numeric.FloatIsConflicted)this, (float)x, (float)y);
    }

    public float minus(float x, float y) {
        return Numeric.FloatIsConflicted.minus$((Numeric.FloatIsConflicted)this, (float)x, (float)y);
    }

    public float times(float x, float y) {
        return Numeric.FloatIsConflicted.times$((Numeric.FloatIsConflicted)this, (float)x, (float)y);
    }

    public float negate(float x) {
        return Numeric.FloatIsConflicted.negate$((Numeric.FloatIsConflicted)this, (float)x);
    }

    public float fromInt(int x) {
        return Numeric.FloatIsConflicted.fromInt$((Numeric.FloatIsConflicted)this, (int)x);
    }

    public float toFloat(float x) {
        return Numeric.FloatIsConflicted.toFloat$((Numeric.FloatIsConflicted)this, (float)x);
    }

    public double toDouble(float x) {
        return Numeric.FloatIsConflicted.toDouble$((Numeric.FloatIsConflicted)this, (float)x);
    }

    public float abs(float x) {
        return Numeric.FloatIsConflicted.abs$((Numeric.FloatIsConflicted)this, (float)x);
    }

    public Object zero() {
        return Numeric.zero$((Numeric)this);
    }

    public Object one() {
        return Numeric.one$((Numeric)this);
    }

    public int signum(Object x) {
        return Numeric.signum$((Numeric)this, (Object)x);
    }

    public Some tryCompare(Object x, Object y) {
        return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.max$((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.min$((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<Object> reverse() {
        return Ordering.reverse$((Ordering)this);
    }

    public <U> Ordering<U> on(Function1<U, Object> f) {
        return Ordering.on$((Ordering)this, f);
    }

    public Ordering.Ops mkOrderingOps(Object lhs) {
        return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
    }

    private int intUpperBound() {
        return this.intUpperBound;
    }

    private int intLowerBound() {
        return this.intLowerBound;
    }

    private long longUpperBound() {
        return this.longUpperBound;
    }

    private long longLowerBound() {
        return this.longLowerBound;
    }

    public int toInt(float x) {
        if (!(Math.floor(x) <= (double)this.intUpperBound()) || !(Math.ceil(x) >= (double)this.intLowerBound())) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToFloat((float)x), FloatType$.MODULE$, IntegerType$.MODULE$);
        }
        return (int)x;
    }

    public long toLong(float x) {
        if (!(Math.floor(x) <= (double)this.longUpperBound()) || !(Math.ceil(x) >= (double)this.longLowerBound())) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToFloat((float)x), FloatType$.MODULE$, LongType$.MODULE$);
        }
        return (long)x;
    }

    public int compare(float x, float y) {
        return SQLOrderingUtil$.MODULE$.compareFloats(x, y);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FloatExactNumeric$() {
        MODULE$ = this;
        PartialOrdering.$init$((PartialOrdering)this);
        Ordering.$init$((Ordering)this);
        Numeric.$init$((Numeric)this);
        Numeric.FloatIsConflicted.$init$((Numeric.FloatIsConflicted)this);
        Fractional.$init$((Fractional)this);
        Numeric.FloatIsFractional.$init$((Numeric.FloatIsFractional)this);
        this.intUpperBound = Integer.MAX_VALUE;
        this.intLowerBound = Integer.MIN_VALUE;
        this.longUpperBound = Long.MAX_VALUE;
        this.longLowerBound = Long.MIN_VALUE;
    }
}

