/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.zookeeper;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kyuubi.shade.org.apache.jute.Record;
import org.apache.kyuubi.shade.org.apache.zookeeper.CreateMode;
import org.apache.kyuubi.shade.org.apache.zookeeper.KeeperException;
import org.apache.kyuubi.shade.org.apache.zookeeper.common.PathUtils;
import org.apache.kyuubi.shade.org.apache.zookeeper.data.ACL;
import org.apache.kyuubi.shade.org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.kyuubi.shade.org.apache.zookeeper.proto.CreateRequest;
import org.apache.kyuubi.shade.org.apache.zookeeper.proto.DeleteRequest;
import org.apache.kyuubi.shade.org.apache.zookeeper.proto.SetDataRequest;

public abstract class Op {
    private int type;
    private String path;

    private Op(int type, String path) {
        this.type = type;
        this.path = path;
    }

    public static Op create(String path, byte[] data, List<ACL> acl, int flags) {
        return new Create(path, data, acl, flags);
    }

    public static Op create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        return new Create(path, data, acl, createMode);
    }

    public static Op delete(String path, int version) {
        return new Delete(path, version);
    }

    public static Op setData(String path, byte[] data, int version) {
        return new SetData(path, data, version);
    }

    public static Op check(String path, int version) {
        return new Check(path, version);
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public abstract Record toRequestRecord();

    abstract Op withChroot(String var1);

    void validate() throws KeeperException {
        PathUtils.validatePath(this.path);
    }

    public static class Check
    extends Op {
        private int version;

        private Check(String path, int version) {
            super(13, path);
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Check)) {
                return false;
            }
            Check op = (Check)o;
            return this.getType() == op.getType() && this.getPath().equals(op.getPath()) && this.version == op.version;
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + this.version;
        }

        @Override
        public Record toRequestRecord() {
            return new CheckVersionRequest(this.getPath(), this.version);
        }

        @Override
        Op withChroot(String path) {
            return new Check(path, this.version);
        }
    }

    public static class SetData
    extends Op {
        private byte[] data;
        private int version;

        private SetData(String path, byte[] data, int version) {
            super(5, path);
            this.data = data;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetData)) {
                return false;
            }
            SetData op = (SetData)o;
            return this.getType() == op.getType() && this.version == op.version && this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + Arrays.hashCode(this.data) + this.version;
        }

        @Override
        public Record toRequestRecord() {
            return new SetDataRequest(this.getPath(), this.data, this.version);
        }

        @Override
        Op withChroot(String path) {
            return new SetData(path, this.data, this.version);
        }
    }

    public static class Delete
    extends Op {
        private int version;

        private Delete(String path, int version) {
            super(2, path);
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete op = (Delete)o;
            return this.getType() == op.getType() && this.version == op.version && this.getPath().equals(op.getPath());
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + this.version;
        }

        @Override
        public Record toRequestRecord() {
            return new DeleteRequest(this.getPath(), this.version);
        }

        @Override
        Op withChroot(String path) {
            return new Delete(path, this.version);
        }
    }

    public static class Create
    extends Op {
        private byte[] data;
        private List<ACL> acl;
        private int flags;

        private Create(String path, byte[] data, List<ACL> acl, int flags) {
            super(1, path);
            this.data = data;
            this.acl = acl;
            this.flags = flags;
        }

        private Create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
            super(1, path);
            this.data = data;
            this.acl = acl;
            this.flags = createMode.toFlag();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Create)) {
                return false;
            }
            Create op = (Create)o;
            boolean aclEquals = true;
            Iterator<ACL> i = op.acl.iterator();
            for (ACL acl : op.acl) {
                boolean hasMoreData = i.hasNext();
                if (!hasMoreData) {
                    aclEquals = false;
                    break;
                }
                ACL otherAcl = i.next();
                if (acl.equals(otherAcl)) continue;
                aclEquals = false;
                break;
            }
            return !i.hasNext() && this.getType() == op.getType() && Arrays.equals(this.data, op.data) && this.flags == op.flags && aclEquals;
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + Arrays.hashCode(this.data);
        }

        @Override
        public Record toRequestRecord() {
            return new CreateRequest(this.getPath(), this.data, this.acl, this.flags);
        }

        @Override
        Op withChroot(String path) {
            return new Create(path, this.data, this.acl, this.flags);
        }

        @Override
        void validate() throws KeeperException {
            CreateMode createMode = CreateMode.fromFlag(this.flags);
            PathUtils.validatePath(this.getPath(), createMode.isSequential());
        }
    }
}

