/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.process;

import org.apache.amoro.Action;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.StateField;
import org.apache.amoro.process.ProcessStage;
import org.apache.amoro.process.TableProcessState;

public abstract class OptimizingState
extends TableProcessState {
    @StateField
    private volatile long targetSnapshotId;
    @StateField
    private volatile long watermark;
    @StateField
    private volatile ProcessStage stage;
    @StateField
    private volatile long currentStageStartTime;

    public OptimizingState(Action action, ServerTableIdentifier tableIdentifier) {
        super(action, tableIdentifier);
    }

    public OptimizingState(long id, Action action, ServerTableIdentifier tableIdentifier) {
        super(id, action, tableIdentifier);
    }

    protected void setStage(ProcessStage stage) {
        this.stage = stage;
        this.currentStageStartTime = System.currentTimeMillis();
    }

    protected void setStage(ProcessStage stage, long stageStartTime) {
        this.stage = stage;
        this.currentStageStartTime = stageStartTime;
    }

    protected void setTargetSnapshotId(long targetSnapshotId) {
        this.targetSnapshotId = targetSnapshotId;
    }

    protected void setWatermark(long watermark) {
        this.watermark = watermark;
    }

    public long getWatermark() {
        return this.watermark;
    }

    @Override
    public ProcessStage getStage() {
        return this.stage;
    }

    public long getTargetSnapshotId() {
        return this.targetSnapshotId;
    }

    public long getCurrentStageStartTime() {
        return this.currentStageStartTime;
    }

    @Override
    public String getName() {
        return this.stage.getDesc();
    }
}

