/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFilePool;
import org.apache.flink.runtime.state.CheckpointedStateScope;

public class NonBlockingPhysicalFilePool
extends PhysicalFilePool {
    public NonBlockingPhysicalFilePool(long maxFileSize, PhysicalFile.PhysicalFileCreator physicalFileCreator) {
        super(maxFileSize, physicalFileCreator);
    }

    @Override
    public boolean tryPutFile(FileMergingSnapshotManager.SubtaskKey subtaskKey, PhysicalFile physicalFile) {
        return physicalFile.getSize() < this.maxFileSize && this.getFileQueue(subtaskKey, physicalFile.getScope()).offer(physicalFile);
    }

    @Override
    @Nonnull
    public PhysicalFile pollFile(FileMergingSnapshotManager.SubtaskKey subtaskKey, CheckpointedStateScope scope) throws IOException {
        PhysicalFile physicalFile = this.getFileQueue(subtaskKey, scope).poll();
        return physicalFile == null ? this.physicalFileCreator.perform(subtaskKey, scope) : physicalFile;
    }

    @Override
    protected Queue<PhysicalFile> createFileQueue() {
        return new ConcurrentLinkedQueue<PhysicalFile>();
    }
}

