/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class MessageTypeToType
extends ParquetTypeVisitor<Type> {
    private static final Joiner DOT = Joiner.on((String)".");
    private final Map<String, Integer> aliasToId = Maps.newHashMap();
    private final Function<String[], Integer> nameToIdFunc;

    MessageTypeToType(Function<String[], Integer> nameToIdFunc) {
        this.nameToIdFunc = nameToIdFunc;
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    @Override
    public Type message(MessageType message, List<Type> fields) {
        Type struct = this.struct((GroupType)message, fields);
        return struct != null ? struct : Types.StructType.of((List)Lists.newArrayList());
    }

    @Override
    public Type struct(GroupType struct, List<Type> fieldTypes) {
        List parquetFields = struct.getFields();
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)fieldTypes.size());
        for (int i = 0; i < parquetFields.size(); ++i) {
            org.apache.parquet.schema.Type field = (org.apache.parquet.schema.Type)parquetFields.get(i);
            Preconditions.checkArgument((!field.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Fields cannot have repetition REPEATED: %s", (Object)field);
            Integer fieldId = this.getId(field);
            Type fieldType = fieldTypes.get(i);
            if (fieldId == null || fieldType == null) continue;
            this.addAlias(field.getName(), fieldId);
            if (((org.apache.parquet.schema.Type)parquetFields.get(i)).isRepetition(Type.Repetition.OPTIONAL)) {
                fields.add(Types.NestedField.optional((int)fieldId, (String)field.getName(), (Type)fieldType));
                continue;
            }
            fields.add(Types.NestedField.required((int)fieldId, (String)field.getName(), (Type)fieldType));
        }
        return fields.isEmpty() ? null : Types.StructType.of((List)fields);
    }

    @Override
    public Type list(GroupType array, Type elementType) {
        org.apache.parquet.schema.Type element = ParquetSchemaUtil.determineListElementType(array);
        Integer elementFieldId = this.getId(element);
        if (elementFieldId != null && elementType != null) {
            this.addAlias(element.getName(), elementFieldId);
            if (element.isRepetition(Type.Repetition.OPTIONAL)) {
                return Types.ListType.ofOptional((int)elementFieldId, (Type)elementType);
            }
            return Types.ListType.ofRequired((int)elementFieldId, (Type)elementType);
        }
        return null;
    }

    @Override
    public Type map(GroupType map, Type keyType, Type valueType) {
        GroupType keyValue = map.getType(0).asGroupType();
        org.apache.parquet.schema.Type key = keyValue.getType(0);
        org.apache.parquet.schema.Type value = keyValue.getType(1);
        Preconditions.checkArgument((!value.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Values cannot have repetition REPEATED: %s", (Object)value);
        Integer keyFieldId = this.getId(key);
        Integer valueFieldId = this.getId(value);
        if (keyFieldId != null && valueFieldId != null && keyType != null && valueType != null) {
            this.addAlias(key.getName(), keyFieldId);
            this.addAlias(value.getName(), valueFieldId);
            if (value.isRepetition(Type.Repetition.OPTIONAL)) {
                return Types.MapType.ofOptional((int)keyFieldId, (int)valueFieldId, (Type)keyType, (Type)valueType);
            }
            return Types.MapType.ofRequired((int)keyFieldId, (int)valueFieldId, (Type)keyType, (Type)valueType);
        }
        return null;
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        Optional converted;
        LogicalTypeAnnotation logicalType = primitive.getLogicalTypeAnnotation();
        if (logicalType != null && (converted = logicalType.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)ParquetLogicalTypeVisitor.get())).isPresent()) {
            return (Type)converted.get();
        }
        switch (primitive.getPrimitiveTypeName()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT32: {
                return Types.IntegerType.get();
            }
            case INT64: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Types.FixedType.ofLength((int)primitive.getTypeLength());
            }
            case INT96: {
                return Types.TimestampType.withZone();
            }
            case BINARY: {
                return Types.BinaryType.get();
            }
        }
        throw new UnsupportedOperationException("Cannot convert unknown primitive type: " + primitive);
    }

    private void addAlias(String name, int fieldId) {
        this.aliasToId.put(DOT.join((Object[])this.path(name)), fieldId);
    }

    private Integer getId(org.apache.parquet.schema.Type type) {
        Type.ID id = type.getId();
        if (id != null) {
            return id.intValue();
        }
        return this.nameToIdFunc.apply(this.path(type.getName()));
    }

    private static class ParquetLogicalTypeVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Type> {
        private static final ParquetLogicalTypeVisitor INSTANCE = new ParquetLogicalTypeVisitor();

        private ParquetLogicalTypeVisitor() {
        }

        private static ParquetLogicalTypeVisitor get() {
            return INSTANCE;
        }

        public Optional<Type> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringType) {
            return Optional.of(Types.StringType.get());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumType) {
            return Optional.of(Types.StringType.get());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType) {
            return Optional.of(Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale()));
        }

        public Optional<Type> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateType) {
            return Optional.of(Types.DateType.get());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType) {
            return Optional.of(Types.TimeType.get());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampType) {
            return Optional.of(timestampType.isAdjustedToUTC() ? Types.TimestampType.withZone() : Types.TimestampType.withoutZone());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intType) {
            Preconditions.checkArgument((intType.isSigned() || intType.getBitWidth() < 64 ? 1 : 0) != 0, (Object)"Cannot use uint64: not a supported Java type");
            if (intType.getBitWidth() < 32) {
                return Optional.of(Types.IntegerType.get());
            }
            if (intType.getBitWidth() == 32 && intType.isSigned()) {
                return Optional.of(Types.IntegerType.get());
            }
            return Optional.of(Types.LongType.get());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonType) {
            return Optional.of(Types.StringType.get());
        }

        public Optional<Type> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonType) {
            return Optional.of(Types.BinaryType.get());
        }
    }
}

