/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.worker;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.worker.CriticalWorker;

public class CriticalSingleThreadExecutor
extends ThreadPoolExecutor
implements CriticalWorker {
    private volatile Thread lastSeenThread;
    private volatile long heartbeatNanos = Long.MAX_VALUE;

    public CriticalSingleThreadExecutor(ThreadFactory threadFactory) {
        this(0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public CriticalSingleThreadExecutor(long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(1, 1, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.lastSeenThread = t;
        this.heartbeatNanos = System.nanoTime();
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            this.heartbeatNanos = Long.MAX_VALUE;
        }
    }

    @Override
    public long threadId() {
        Thread thread = this.lastSeenThread;
        assert (thread != null);
        return thread.getId();
    }

    @Override
    public long heartbeatNanos() {
        return this.heartbeatNanos;
    }
}

