/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.agg;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteColocatedAggregateBase;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteSortAggregateBase;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;

public class IgniteColocatedSortAggregate
extends IgniteColocatedAggregateBase
implements IgniteSortAggregateBase {
    private static final String REL_TYPE_NAME = "ColocatedSortAggregate";
    private final RelCollation collation;

    public IgniteColocatedSortAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        this.collation = TraitUtils.collation(traitSet);
    }

    public IgniteColocatedSortAggregate(RelInput input) {
        super(input);
        this.collation = input.getCollation();
        assert (Objects.nonNull(this.collation));
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new IgniteColocatedSortAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteColocatedSortAggregate(cluster, this.getTraitSet().replace((RelTrait)this.collation), (RelNode)IgniteColocatedSortAggregate.sole(inputs), this.getGroupSet(), (List<ImmutableBitSet>)this.getGroupSets(), this.getAggCallList());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("collation", (Object)this.collation);
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeSelfCostSort(planner, mq);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return super.explain(writer).addCollation(this.collation, this.getRowType());
    }
}

