/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.util.PlainTableRenderer;
import org.apache.ignite3.rest.client.model.Metric;
import org.apache.ignite3.rest.client.model.MetricSet;

public class MetricSetListDecorator
implements Decorator<List<MetricSet>, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"Set name", "Metric name", "Description"};
    private final boolean plain;

    public MetricSetListDecorator(boolean plain) {
        this.plain = plain;
    }

    @Override
    public TerminalOutput decorate(List<MetricSet> data) {
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, MetricSetListDecorator.metricSetsToContent(data));
        }
        return () -> FlipTable.of((String[])HEADERS, (String[][])MetricSetListDecorator.metricSetsToContent(data));
    }

    private static String[][] metricSetsToContent(List<MetricSet> data) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (MetricSet metricSet : data) {
            result.add(new String[]{metricSet.getName(), "", ""});
            for (Metric metric : metricSet.getMetrics()) {
                String desc = metric.getDesc();
                result.add(new String[]{"", metric.getName(), desc != null ? desc : ""});
            }
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }
}

