/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BooleanIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ByteIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BytesIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.CacheJavaObjectIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DateIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DecimalIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DoubleIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.FloatIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IntegerIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.LongIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.PlainJavaObjectIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ShortIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.SignedBytesIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.StringIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.TimeIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.TimestampIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.UuidIndexKey;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;

public class IndexKeyFactory {
    private static final Map<IndexKeyType, Function<Object, IndexKey>> registry = new EnumMap<IndexKeyType, Function<Object, IndexKey>>(IndexKeyType.class);

    public static void register(IndexKeyType keyType, Function<Object, IndexKey> wrapper) {
        registry.put(keyType, wrapper);
    }

    public static IndexKey wrap(Object o, int keyType, CacheObjectValueContext coctx, IndexKeyTypeSettings keyTypeSettings) {
        return IndexKeyFactory.wrap(o, IndexKeyType.forCode(keyType), coctx, keyTypeSettings);
    }

    public static IndexKey wrap(Object o, IndexKeyType keyType, CacheObjectValueContext coctx, IndexKeyTypeSettings keyTypeSettings) {
        if (o == null || keyType == IndexKeyType.NULL) {
            return NullIndexKey.INSTANCE;
        }
        switch (keyType) {
            case BOOLEAN: {
                return new BooleanIndexKey((Boolean)o);
            }
            case BYTE: {
                return new ByteIndexKey((Byte)o);
            }
            case SHORT: {
                return new ShortIndexKey((Short)o);
            }
            case INT: {
                return new IntegerIndexKey((Integer)o);
            }
            case LONG: {
                return new LongIndexKey((Long)o);
            }
            case DECIMAL: {
                return new DecimalIndexKey((BigDecimal)o);
            }
            case DOUBLE: {
                return new DoubleIndexKey((Double)o);
            }
            case FLOAT: {
                return new FloatIndexKey(((Float)o).floatValue());
            }
            case BYTES: {
                return keyTypeSettings.binaryUnsigned() ? new BytesIndexKey((byte[])o) : new SignedBytesIndexKey((byte[])o);
            }
            case STRING: {
                return new StringIndexKey((String)o);
            }
            case UUID: {
                return new UuidIndexKey((UUID)o);
            }
            case JAVA_OBJECT: {
                if (BinaryObjectImpl.class == o.getClass()) {
                    return new CacheJavaObjectIndexKey((CacheObject)o, coctx);
                }
                return new PlainJavaObjectIndexKey(o, null);
            }
            case DATE: {
                return new DateIndexKey(o);
            }
            case TIME: {
                return new TimeIndexKey(o);
            }
            case TIMESTAMP: {
                return new TimestampIndexKey(o);
            }
        }
        if (registry.containsKey((Object)keyType)) {
            return registry.get((Object)keyType).apply(o);
        }
        throw new IgniteException("Failed to wrap value [type=" + keyType + ", value=" + o + "]");
    }
}

