/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.model.ExternalView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ExternalViewCache
extends AbstractDataCache<ExternalView> {
    private static final Logger LOG = LoggerFactory.getLogger((String)ExternalViewCache.class.getName());
    protected Map<String, ExternalView> _externalViewMap;
    protected Map<String, ExternalView> _externalViewCache;
    protected String _clusterName;
    private PropertyType _type;

    public ExternalViewCache(String clusterName) {
        this(clusterName, PropertyType.EXTERNALVIEW);
    }

    protected ExternalViewCache(String clusterName, PropertyType type) {
        super(ExternalViewCache.createDefaultControlContextProvider(clusterName));
        this._clusterName = clusterName;
        this._externalViewMap = Collections.emptyMap();
        this._externalViewCache = Collections.emptyMap();
        this._type = type;
    }

    public void refresh(HelixDataAccessor accessor) {
        long startTime = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashSet<PropertyKey> currentPropertyKeys = new HashSet<PropertyKey>();
        List<String> resources = accessor.getChildNames(this.externalViewsKey(keyBuilder));
        for (String resource : resources) {
            currentPropertyKeys.add(this.externalViewKey(keyBuilder, resource));
        }
        HashSet<PropertyKey> cachedKeys = new HashSet<PropertyKey>();
        HashMap cachedExternalViewMap = Maps.newHashMap();
        for (String resource : this._externalViewCache.keySet()) {
            PropertyKey key = this.externalViewKey(keyBuilder, resource);
            cachedKeys.add(key);
            cachedExternalViewMap.put(key, this._externalViewCache.get(resource));
        }
        cachedKeys.retainAll(currentPropertyKeys);
        HashSet<PropertyKey> reloadKeys = new HashSet<PropertyKey>(currentPropertyKeys);
        reloadKeys.removeAll(cachedKeys);
        Map updatedMap = this.refreshProperties(accessor, reloadKeys, new ArrayList<PropertyKey>(cachedKeys), cachedExternalViewMap, new HashSet<PropertyKey>());
        HashMap newExternalViewMap = Maps.newHashMap();
        for (ExternalView externalView : updatedMap.values()) {
            newExternalViewMap.put(externalView.getResourceName(), externalView);
        }
        this._externalViewCache = new HashMap<String, ExternalView>(newExternalViewMap);
        this._externalViewMap = new HashMap<String, ExternalView>(newExternalViewMap);
        long endTime = System.currentTimeMillis();
        LOG.info("Refresh " + this._externalViewMap.size() + " ExternalViews for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
    }

    private PropertyKey externalViewsKey(PropertyKey.Builder keyBuilder) {
        PropertyKey evPropertyKey;
        if (this._type.equals((Object)PropertyType.EXTERNALVIEW)) {
            evPropertyKey = keyBuilder.externalViews();
        } else if (this._type.equals((Object)PropertyType.TARGETEXTERNALVIEW)) {
            evPropertyKey = keyBuilder.targetExternalViews();
        } else {
            throw new HelixException("Failed to refresh ExternalViewCache, Wrong property type " + this._type + "!");
        }
        return evPropertyKey;
    }

    private PropertyKey externalViewKey(PropertyKey.Builder keyBuilder, String resource) {
        PropertyKey evPropertyKey;
        if (this._type.equals((Object)PropertyType.EXTERNALVIEW)) {
            evPropertyKey = keyBuilder.externalView(resource);
        } else if (this._type.equals((Object)PropertyType.TARGETEXTERNALVIEW)) {
            evPropertyKey = keyBuilder.targetExternalView(resource);
        } else {
            throw new HelixException("Failed to refresh ExternalViewCache, Wrong property type " + this._type + "!");
        }
        return evPropertyKey;
    }

    public Map<String, ExternalView> getExternalViewMap() {
        return Collections.unmodifiableMap(this._externalViewMap);
    }

    public void clear() {
        this._externalViewCache.clear();
        this._externalViewMap.clear();
    }
}

