/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.functions;

import java.util.Set;
import java.util.concurrent.CancellationException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RebalanceFunction
implements InternalFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = RebalanceFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext<Object[]> context) {
        Cache cache = context.getCache();
        ResourceManager manager = cache.getResourceManager();
        Object[] args = context.getArguments();
        String simulate = (String)args[0];
        Set includeRegionNames = (Set)args[1];
        Set excludeRegionNames = (Set)args[2];
        RebalanceFactory rbFactory = manager.createRebalanceFactory();
        rbFactory.excludeRegions(excludeRegionNames);
        rbFactory.includeRegions(includeRegionNames);
        RebalanceOperation op = simulate.equals("true") ? rbFactory.simulate() : rbFactory.start();
        try {
            RebalanceResults results = op.getResults();
            logger.info("Starting RebalanceFunction got results = {}", (Object)results);
            StringBuilder str1 = new StringBuilder();
            str1.append(results.getTotalBucketCreateBytes()).append(",").append(results.getTotalBucketCreateTime()).append(",").append(results.getTotalBucketCreatesCompleted()).append(",").append(results.getTotalBucketTransferBytes()).append(",").append(results.getTotalBucketTransferTime()).append(",").append(results.getTotalBucketTransfersCompleted()).append(",").append(results.getTotalPrimaryTransferTime()).append(",").append(results.getTotalPrimaryTransfersCompleted()).append(",").append(results.getTotalTime()).append(",").append(results.getTotalMembersExecutedOn()).append(",").append(String.join((CharSequence)",", includeRegionNames));
            logger.info("Starting RebalanceFunction str1={}", (Object)str1);
            context.getResultSender().lastResult(str1.toString());
        }
        catch (CancellationException e) {
            logger.info("Starting RebalanceFunction CancellationException: {} {}", (Object)e.getMessage(), (Object)e);
            context.getResultSender().lastResult("CancellationException1 " + e.getMessage());
        }
        catch (InterruptedException e) {
            logger.info("Starting RebalanceFunction InterruptedException: {}", (Object)e.getMessage(), (Object)e);
            context.getResultSender().lastResult("InterruptedException2 " + e.getMessage());
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

