/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.validators;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RegionNameValidation;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.configuration.RegionType;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;
import org.apache.geode.security.ResourcePermission;

public class RegionConfigValidator
implements ConfigurationValidator<Region> {
    private final InternalCache cache;

    public RegionConfigValidator(InternalCache cache) {
        this.cache = cache;
    }

    @Override
    public void validate(CacheElementOperation operation, Region config) throws IllegalArgumentException {
        switch (operation) {
            case UPDATE: {
                throw new NotImplementedException("Not implemented");
            }
            case CREATE: {
                this.validateCreate(config);
                break;
            }
            case DELETE: {
                this.validateDelete((AbstractConfiguration)config);
            }
        }
    }

    private void validateDelete(AbstractConfiguration config) {
        if (StringUtils.isNotBlank((CharSequence)config.getGroup())) {
            throw new IllegalArgumentException("Group is an invalid option when deleting region.");
        }
    }

    private void validateCreate(Region config) {
        List expirations;
        if (config.getType() == null) {
            throw new IllegalArgumentException("Region type is required.");
        }
        if (config.getType() == RegionType.LEGACY) {
            throw new IllegalArgumentException("Region type is unsupported.");
        }
        Integer redundantCopies = config.getRedundantCopies();
        if (redundantCopies != null && (redundantCopies < 0 || redundantCopies > 3)) {
            throw new IllegalArgumentException("redundantCopies cannot be less than 0 or greater than 3.");
        }
        if (!config.getType().withPartition() && config.getRedundantCopies() != null) {
            throw new IllegalArgumentException("redundantCopies can only be set with PARTITION regions.");
        }
        RegionNameValidation.validate(config.getName());
        if (config.getType().name().contains("PERSISTENT")) {
            this.cache.getSecurityService().authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        if ((expirations = config.getExpirations()) != null) {
            HashSet<Region.ExpirationType> existingTypes = new HashSet<Region.ExpirationType>();
            for (Region.Expiration expiration : expirations) {
                this.validate(expiration);
                if (existingTypes.contains(expiration.getType())) {
                    throw new IllegalArgumentException("Can not have multiple " + expiration.getType() + ".");
                }
                existingTypes.add(expiration.getType());
            }
        }
        this.validateEviction(config.getEviction());
    }

    private void validateEviction(Region.Eviction eviction) {
        if (eviction == null) {
            return;
        }
        Region.EvictionType type = eviction.getType();
        if (type == null) {
            throw new IllegalArgumentException("Eviction type must be set.");
        }
        switch (type) {
            case ENTRY_COUNT: {
                if (eviction.getEntryCount() == null) {
                    throw new IllegalArgumentException("EntryCount must be set for: " + type);
                }
                if (eviction.getObjectSizer() == null) break;
                throw new IllegalArgumentException("ObjectSizer must not be set for: " + type);
            }
            case MEMORY_SIZE: {
                if (eviction.getMemorySizeMb() != null) break;
                throw new IllegalArgumentException("MemorySizeMb must be set for: " + type);
            }
        }
    }

    private void validate(Region.Expiration expiration) {
        if (expiration.getType() == null) {
            throw new IllegalArgumentException("Expiration type must be set.");
        }
        if (expiration.getType() == Region.ExpirationType.LEGACY) {
            throw new IllegalArgumentException("Invalid Expiration type.");
        }
        if (expiration.getTimeInSeconds() == null || expiration.getTimeInSeconds() < 0) {
            throw new IllegalArgumentException("Expiration timeInSeconds must be greater than or equal to 0.");
        }
        if (expiration.getAction() == Region.ExpirationAction.LEGACY) {
            throw new IllegalArgumentException("Invalid Expiration action.");
        }
    }
}

