/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFormatter {
    public static final String FORMAT_STRING = "yyyy/MM/dd HH:mm:ss.SSS z";
    public static final String LOCALIZED_FORMAT_STRING = "EEE yyyy/MM/dd HH:mm:ss zzz";

    public static DateFormat createDateFormat() {
        return new SimpleDateFormat(FORMAT_STRING);
    }

    public static SimpleDateFormat createLocalizedDateFormat() {
        String pattern = new SimpleDateFormat().toLocalizedPattern();
        return new SimpleDateFormat(DateFormatter.getModifiedLocalizedPattern(pattern), Locale.getDefault());
    }

    static String getModifiedLocalizedPattern(String pattern) {
        String pattern_to_use;
        if (pattern.contains("mm")) {
            if (!pattern.contains("ss")) {
                int mm = pattern.indexOf("mm");
                pattern_to_use = pattern.substring(0, mm + 2) + ":ss" + pattern.substring(mm + 2);
            } else {
                pattern_to_use = pattern;
            }
            if (!pattern_to_use.contains("EEE")) {
                pattern_to_use = "EEE " + pattern_to_use;
            }
            if (!pattern_to_use.contains("zzz")) {
                pattern_to_use = pattern_to_use + " zzz";
            }
        } else {
            pattern_to_use = LOCALIZED_FORMAT_STRING;
        }
        return pattern_to_use;
    }

    public static DateFormat createDateFormat(String formatString) {
        return new SimpleDateFormat(formatString);
    }

    public static String getTimeStamp() {
        return DateFormatter.formatDate(new Date());
    }

    public static String formatDate(Date d) {
        try {
            return DateFormatter.createDateFormat().format(d);
        }
        catch (Exception e1) {
            try {
                return d.toString();
            }
            catch (Exception e2) {
                try {
                    return Long.toString(d.getTime());
                }
                catch (Exception e3) {
                    return "timestampFormatFailed";
                }
            }
        }
    }

    private DateFormatter() {
    }
}

