/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.jetbrains.annotations.NotNull;

public class GetPDXEnumById
extends BaseCommand {
    @Immutable
    private static final GetPDXEnumById singleton = new GetPDXEnumById();

    public static Command getCommand() {
        return singleton;
    }

    private GetPDXEnumById() {
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        EnumInfo result;
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx enum by id request ({} parts) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getNumberOfParts(), (Object)serverConnection.getSocketString());
        }
        int enumId = clientMessage.getPart(0).getInt();
        try {
            InternalCache cache = serverConnection.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            result = registry.getEnumInfoById(enumId);
        }
        catch (Exception e) {
            GetPDXEnumById.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(clientMessage.getTransactionId());
        responseMsg.addObjPart(result);
        responseMsg.send(serverConnection);
        serverConnection.setAsTrue(1);
    }
}

