/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.time.Duration;
import java.time.Instant;
import java.util.function.BooleanSupplier;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;

public class MembershipChangeListener
implements MembershipListener,
PersistentStateListener {
    private static final int POLL_INTERVAL_MILLIS = 100;
    private final Duration pollDuration;
    private final Duration warningDelay;
    private final BooleanSupplier cancelCondition;
    private final Runnable warning;
    private boolean membershipChanged;
    private boolean warned;

    MembershipChangeListener(Duration warningDelay, Duration pollDuration, BooleanSupplier cancelCondition, Runnable warning) {
        this.warningDelay = warningDelay;
        this.pollDuration = pollDuration;
        this.cancelCondition = cancelCondition;
        this.warning = warning;
    }

    public synchronized void waitForChange() throws InterruptedException {
        Instant now = Instant.now();
        Instant timeoutTime = now.plus(this.pollDuration);
        Instant warningTime = now.plus(this.warningDelay);
        while (!this.membershipChanged && !this.cancelCondition.getAsBoolean() && Instant.now().isBefore(timeoutTime)) {
            this.warnOnceAfter(warningTime);
            this.wait(100L);
        }
        this.membershipChanged = false;
    }

    private void warnOnceAfter(Instant warningTime) {
        if (!this.warned && warningTime.isBefore(Instant.now())) {
            this.warning.run();
            this.warned = true;
        }
    }

    private synchronized void afterMembershipChange() {
        this.membershipChanged = true;
        this.notifyAll();
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        this.afterMembershipChange();
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        this.afterMembershipChange();
    }

    @Override
    public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.afterMembershipChange();
    }

    @Override
    public void memberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.afterMembershipChange();
    }

    @Override
    public void memberRemoved(PersistentMemberID id, boolean revoked) {
        this.afterMembershipChange();
    }
}

