/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class RecoveryRunnable
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    protected final PRHARedundancyProvider redundancyProvider;
    private volatile Throwable failure;

    public RecoveryRunnable(PRHARedundancyProvider prhaRedundancyProvider) {
        this.redundancyProvider = prhaRedundancyProvider;
    }

    public abstract void run2();

    public void checkFailure() {
        if (this.failure != null) {
            if (this.failure instanceof RuntimeException) {
                throw (RuntimeException)this.failure;
            }
            throw new InternalGemFireError("Failure during bucket recovery ", this.failure);
        }
    }

    @Override
    public void run() {
        CancelCriterion stopper = this.redundancyProvider.getPartitionedRegion().getGemFireCache().getDistributedSystem().getCancelCriterion();
        DistributedSystem.setThreadsSocketPolicy(true);
        SystemFailure.checkFailure();
        if (stopper.isCancelInProgress()) {
            return;
        }
        try {
            this.run2();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (logger.isDebugEnabled()) {
                logger.debug("Unexpected exception in PR redundancy recovery", t);
            }
            this.failure = t;
        }
    }
}

