/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.FixedPartitionAttributes;

public class FixedPartitionAttributesImpl
extends FixedPartitionAttributes
implements DataSerializable {
    private static final long serialVersionUID = 7435010874879693776L;
    private String partitionName;
    private boolean isPrimary = false;
    private int numBuckets = 1;
    private int startingBucketID = -1;

    @Override
    public String getPartitionName() {
        return this.partitionName;
    }

    @Override
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.partitionName = DataSerializer.readString(in);
        this.isPrimary = in.readBoolean();
        this.numBuckets = in.readInt();
        this.startingBucketID = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.partitionName, out);
        out.writeBoolean(this.isPrimary);
        out.writeInt(this.numBuckets);
        out.writeInt(this.startingBucketID);
    }

    public FixedPartitionAttributesImpl setPartitionName(String name) {
        this.partitionName = name;
        return this;
    }

    public FixedPartitionAttributesImpl isPrimary(boolean isPrimary2) {
        this.isPrimary = isPrimary2;
        return this;
    }

    public FixedPartitionAttributesImpl setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
        return this;
    }

    public void setStartingBucketID(int startingBucketID) {
        this.startingBucketID = startingBucketID;
    }

    public int getStartingBucketID() {
        return this.startingBucketID;
    }

    public int getLastBucketID() {
        return this.startingBucketID + this.numBuckets - 1;
    }

    public boolean hasBucket(int bucketId) {
        return this.getStartingBucketID() <= bucketId && bucketId <= this.getLastBucketID();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedPartitionAttributesImpl)) {
            return false;
        }
        FixedPartitionAttributesImpl spr = (FixedPartitionAttributesImpl)obj;
        return spr.getPartitionName().equals(this.getPartitionName());
    }

    public int hashCode() {
        return this.getPartitionName().hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("FixedPartitionAttributes@").append("[partitionName=").append(this.partitionName).append(";isPrimary=").append(this.isPrimary).append(";numBuckets=").append(this.numBuckets);
        if (Boolean.getBoolean("gemfire.PRDebug")) {
            s.append(";startingBucketID= ").append(this.startingBucketID);
        }
        s.append("]");
        return s.toString();
    }
}

