/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.EvictionAttributesImpl;

public class RemoteRegionAttributes
implements RegionAttributes,
DataSerializable {
    private static final long serialVersionUID = -4989613295006261809L;
    private String cacheLoaderDesc;
    private String cacheWriterDesc;
    private String capacityControllerDesc;
    private String[] cacheListenerDescs;
    private Class keyConstraint;
    private Class valueConstraint;
    private ExpirationAttributes rTtl;
    private ExpirationAttributes rIdleTimeout;
    private ExpirationAttributes eTtl;
    private String customEttlDesc;
    private ExpirationAttributes eIdleTimeout;
    private String customEIdleDesc;
    private DataPolicy dataPolicy;
    private Scope scope;
    private boolean statsEnabled;
    private boolean ignoreJTA;
    private boolean isLockGrantor;
    private int concurrencyLevel;
    private boolean concurrencyChecksEnabled;
    private float loadFactor;
    private int initialCapacity;
    private boolean earlyAck;
    private boolean multicastEnabled;
    private boolean enableGateway;
    private String gatewayHubId;
    private boolean enableSubscriptionConflation;
    private boolean publisher;
    private boolean enableAsyncConflation;
    private DiskWriteAttributes diskWriteAttributes;
    private File[] diskDirs;
    private int[] diskSizes;
    private boolean indexMaintenanceSynchronous;
    private PartitionAttributes partitionAttributes;
    private MembershipAttributes membershipAttributes;
    private SubscriptionAttributes subscriptionAttributes;
    private EvictionAttributesImpl evictionAttributes = new EvictionAttributesImpl();
    private boolean cloningEnable;
    private String poolName;
    private String diskStoreName;
    private boolean isDiskSynchronous;
    private String[] gatewaySendersDescs;
    private boolean isGatewaySenderEnabled = false;
    private String[] asyncEventQueueDescs;
    private String compressorDesc;
    private boolean offHeap;
    @Immutable
    private static final CacheListener[] EMPTY_LISTENERS = new CacheListener[0];

    public RemoteRegionAttributes(RegionAttributes attr) {
        this.cacheLoaderDesc = this.getDesc(attr.getCacheLoader());
        this.cacheWriterDesc = this.getDesc(attr.getCacheWriter());
        this.cacheListenerDescs = this.getDescs(attr.getCacheListeners());
        this.keyConstraint = attr.getKeyConstraint();
        this.valueConstraint = attr.getValueConstraint();
        this.rTtl = attr.getRegionTimeToLive();
        this.rIdleTimeout = attr.getRegionIdleTimeout();
        this.eTtl = attr.getEntryTimeToLive();
        this.customEttlDesc = this.getDesc(attr.getCustomEntryTimeToLive());
        this.eIdleTimeout = attr.getEntryIdleTimeout();
        this.customEIdleDesc = this.getDesc(attr.getCustomEntryIdleTimeout());
        this.dataPolicy = attr.getDataPolicy();
        this.scope = attr.getScope();
        this.statsEnabled = attr.getStatisticsEnabled();
        this.ignoreJTA = attr.getIgnoreJTA();
        this.concurrencyLevel = attr.getConcurrencyLevel();
        this.concurrencyChecksEnabled = attr.getConcurrencyChecksEnabled();
        this.loadFactor = attr.getLoadFactor();
        this.initialCapacity = attr.getInitialCapacity();
        this.earlyAck = attr.getEarlyAck();
        this.multicastEnabled = attr.getMulticastEnabled();
        this.enableSubscriptionConflation = attr.getEnableSubscriptionConflation();
        this.publisher = attr.getPublisher();
        this.enableAsyncConflation = attr.getEnableAsyncConflation();
        this.diskStoreName = attr.getDiskStoreName();
        if (this.diskStoreName == null) {
            this.diskWriteAttributes = attr.getDiskWriteAttributes();
            this.diskDirs = attr.getDiskDirs();
            this.diskSizes = attr.getDiskDirSizes();
        } else {
            this.diskWriteAttributes = null;
            this.diskDirs = null;
            this.diskSizes = null;
        }
        this.partitionAttributes = attr.getPartitionAttributes();
        this.membershipAttributes = attr.getMembershipAttributes();
        this.subscriptionAttributes = attr.getSubscriptionAttributes();
        this.cloningEnable = attr.getCloningEnabled();
        this.poolName = attr.getPoolName();
        this.isDiskSynchronous = attr.isDiskSynchronous();
        this.gatewaySendersDescs = this.getDescs(attr.getGatewaySenderIds().toArray());
        this.asyncEventQueueDescs = this.getDescs(attr.getAsyncEventQueueIds().toArray());
        this.compressorDesc = this.getDesc(attr.getCompressor());
        this.offHeap = attr.getOffHeap();
    }

    public RemoteRegionAttributes() {
    }

    public CacheLoader getCacheLoader() {
        return this.cacheLoaderDesc.equals("") ? null : new RemoteCacheLoader(this.cacheLoaderDesc);
    }

    public CacheWriter getCacheWriter() {
        return this.cacheWriterDesc.equals("") ? null : new RemoteCacheWriter(this.cacheWriterDesc);
    }

    public Class getKeyConstraint() {
        return this.keyConstraint;
    }

    public Class getValueConstraint() {
        return this.valueConstraint;
    }

    @Override
    public ExpirationAttributes getRegionTimeToLive() {
        return this.rTtl;
    }

    @Override
    public ExpirationAttributes getRegionIdleTimeout() {
        return this.rIdleTimeout;
    }

    @Override
    public ExpirationAttributes getEntryTimeToLive() {
        return this.eTtl;
    }

    public CustomExpiry getCustomEntryTimeToLive() {
        return this.customEttlDesc.equals("") ? null : new RemoteCustomExpiry(this.customEttlDesc);
    }

    @Override
    public ExpirationAttributes getEntryIdleTimeout() {
        return this.eIdleTimeout;
    }

    public CustomExpiry getCustomEntryIdleTimeout() {
        return this.customEIdleDesc.equals("") ? null : new RemoteCustomExpiry(this.customEIdleDesc);
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public CacheListener getCacheListener() {
        CacheListener[] listeners = this.getCacheListeners();
        if (listeners.length == 0) {
            return null;
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        throw new IllegalStateException("More than one cache listener exists.");
    }

    public CacheListener[] getCacheListeners() {
        if (this.cacheListenerDescs == null || this.cacheListenerDescs.length == 0) {
            return EMPTY_LISTENERS;
        }
        CacheListener[] result = new CacheListener[this.cacheListenerDescs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new RemoteCacheListener(this.cacheListenerDescs[i]);
        }
        return result;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float getLoadFactor() {
        return this.loadFactor;
    }

    @Override
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public boolean getIgnoreJTA() {
        return this.ignoreJTA;
    }

    @Override
    public boolean isLockGrantor() {
        return this.isLockGrantor;
    }

    @Override
    public boolean getPersistBackup() {
        return this.getDataPolicy().withPersistence();
    }

    @Override
    public boolean getEarlyAck() {
        return this.earlyAck;
    }

    @Override
    public boolean getMulticastEnabled() {
        return this.multicastEnabled;
    }

    public boolean getEnableGateway() {
        return this.enableGateway;
    }

    public boolean getEnableWAN() {
        return this.enableGateway;
    }

    public String getGatewayHubId() {
        return this.gatewayHubId;
    }

    @Override
    @Deprecated
    public boolean getPublisher() {
        return this.publisher;
    }

    @Override
    public boolean getEnableConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableBridgeConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    @Override
    public boolean getEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    @Override
    public DiskWriteAttributes getDiskWriteAttributes() {
        return this.diskWriteAttributes;
    }

    @Override
    public File[] getDiskDirs() {
        return this.diskDirs;
    }

    @Override
    public int[] getDiskDirSizes() {
        return this.diskSizes;
    }

    @Override
    public MirrorType getMirrorType() {
        if (this.dataPolicy.isNormal() || this.dataPolicy.isPreloaded() || this.dataPolicy.isEmpty() || this.dataPolicy.withPartitioning()) {
            return MirrorType.NONE;
        }
        if (this.dataPolicy.withReplication()) {
            return MirrorType.KEYS_VALUES;
        }
        throw new IllegalStateException(String.format("No mirror type corresponds to data policy %s", this.dataPolicy));
    }

    @Override
    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    @Override
    public PartitionAttributes getPartitionAttributes() {
        return this.partitionAttributes;
    }

    @Override
    public MembershipAttributes getMembershipAttributes() {
        return this.membershipAttributes;
    }

    @Override
    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.subscriptionAttributes;
    }

    @Override
    public Compressor getCompressor() {
        return this.compressorDesc.equals("") ? null : new RemoteCompressor(this.compressorDesc);
    }

    @Override
    public boolean getOffHeap() {
        return this.offHeap;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.cacheLoaderDesc, out);
        DataSerializer.writeString(this.cacheWriterDesc, out);
        DataSerializer.writeStringArray(this.cacheListenerDescs, out);
        DataSerializer.writeString(this.capacityControllerDesc, out);
        DataSerializer.writeObject(this.keyConstraint, out);
        DataSerializer.writeObject(this.valueConstraint, out);
        DataSerializer.writeObject(this.rTtl, out);
        DataSerializer.writeObject(this.rIdleTimeout, out);
        DataSerializer.writeObject(this.eTtl, out);
        DataSerializer.writeString(this.customEttlDesc, out);
        DataSerializer.writeObject(this.eIdleTimeout, out);
        DataSerializer.writeString(this.customEIdleDesc, out);
        DataSerializer.writeObject(this.dataPolicy, out);
        DataSerializer.writeObject(this.scope, out);
        out.writeBoolean(this.statsEnabled);
        out.writeBoolean(this.ignoreJTA);
        out.writeInt(this.concurrencyLevel);
        out.writeFloat(this.loadFactor);
        out.writeInt(this.initialCapacity);
        out.writeBoolean(this.earlyAck);
        out.writeBoolean(this.multicastEnabled);
        out.writeBoolean(this.enableSubscriptionConflation);
        out.writeBoolean(this.publisher);
        out.writeBoolean(this.enableAsyncConflation);
        DataSerializer.writeObject(this.diskWriteAttributes, out);
        DataSerializer.writeObject(this.diskDirs, out);
        DataSerializer.writeObject(this.diskSizes, out);
        out.writeBoolean(this.indexMaintenanceSynchronous);
        DataSerializer.writeObject(this.partitionAttributes, out);
        DataSerializer.writeObject(this.membershipAttributes, out);
        DataSerializer.writeObject(this.subscriptionAttributes, out);
        DataSerializer.writeObject(this.evictionAttributes, out);
        out.writeBoolean(this.cloningEnable);
        DataSerializer.writeString(this.diskStoreName, out);
        out.writeBoolean(this.isDiskSynchronous);
        DataSerializer.writeStringArray(this.gatewaySendersDescs, out);
        out.writeBoolean(this.isGatewaySenderEnabled);
        out.writeBoolean(this.concurrencyChecksEnabled);
        DataSerializer.writeString(this.compressorDesc, out);
        out.writeBoolean(this.offHeap);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.cacheLoaderDesc = DataSerializer.readString(in);
        this.cacheWriterDesc = DataSerializer.readString(in);
        this.cacheListenerDescs = DataSerializer.readStringArray(in);
        this.capacityControllerDesc = DataSerializer.readString(in);
        this.keyConstraint = (Class)DataSerializer.readObject(in);
        this.valueConstraint = (Class)DataSerializer.readObject(in);
        this.rTtl = (ExpirationAttributes)DataSerializer.readObject(in);
        this.rIdleTimeout = (ExpirationAttributes)DataSerializer.readObject(in);
        this.eTtl = (ExpirationAttributes)DataSerializer.readObject(in);
        this.customEttlDesc = DataSerializer.readString(in);
        this.eIdleTimeout = (ExpirationAttributes)DataSerializer.readObject(in);
        this.customEIdleDesc = DataSerializer.readString(in);
        this.dataPolicy = (DataPolicy)DataSerializer.readObject(in);
        this.scope = (Scope)DataSerializer.readObject(in);
        this.statsEnabled = in.readBoolean();
        this.ignoreJTA = in.readBoolean();
        this.concurrencyLevel = in.readInt();
        this.loadFactor = in.readFloat();
        this.initialCapacity = in.readInt();
        this.earlyAck = in.readBoolean();
        this.multicastEnabled = in.readBoolean();
        this.enableSubscriptionConflation = in.readBoolean();
        this.publisher = in.readBoolean();
        this.enableAsyncConflation = in.readBoolean();
        this.diskWriteAttributes = (DiskWriteAttributes)DataSerializer.readObject(in);
        this.diskDirs = (File[])DataSerializer.readObject(in);
        this.diskSizes = (int[])DataSerializer.readObject(in);
        this.indexMaintenanceSynchronous = in.readBoolean();
        this.partitionAttributes = (PartitionAttributes)DataSerializer.readObject(in);
        this.membershipAttributes = (MembershipAttributes)DataSerializer.readObject(in);
        this.subscriptionAttributes = (SubscriptionAttributes)DataSerializer.readObject(in);
        this.evictionAttributes = (EvictionAttributesImpl)DataSerializer.readObject(in);
        this.cloningEnable = in.readBoolean();
        this.diskStoreName = DataSerializer.readString(in);
        this.isDiskSynchronous = in.readBoolean();
        this.gatewaySendersDescs = DataSerializer.readStringArray(in);
        this.isGatewaySenderEnabled = in.readBoolean();
        this.concurrencyChecksEnabled = in.readBoolean();
        this.compressorDesc = DataSerializer.readString(in);
        this.offHeap = in.readBoolean();
    }

    private String[] getDescs(Object[] l) {
        if (l == null) {
            return new String[0];
        }
        String[] result = new String[l.length];
        for (int i = 0; i < l.length; ++i) {
            result[i] = this.getDesc(l[i]);
        }
        return result;
    }

    private String getDesc(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof RemoteCacheCallback) {
            return o.toString();
        }
        return o.getClass().getName();
    }

    @Override
    public boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    @Override
    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    @Override
    public boolean getCloningEnabled() {
        return this.cloningEnable;
    }

    @Override
    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.isDiskSynchronous;
    }

    public boolean isGatewaySenderEnabled() {
        return this.isGatewaySenderEnabled;
    }

    @Override
    public Set<String> getGatewaySenderIds() {
        if (this.gatewaySendersDescs == null || this.gatewaySendersDescs.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> senderIds = new HashSet<String>();
        String[] result = new String[this.gatewaySendersDescs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.gatewaySendersDescs[i];
            senderIds.add(result[i]);
        }
        return senderIds;
    }

    @Override
    public Set<String> getAsyncEventQueueIds() {
        if (this.asyncEventQueueDescs == null || this.asyncEventQueueDescs.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> asyncEventQueues = new HashSet<String>();
        String[] result = new String[this.asyncEventQueueDescs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.asyncEventQueueDescs[i];
            asyncEventQueues.add(result[i]);
        }
        return asyncEventQueues;
    }

    private static class RemoteCompressor
    extends RemoteCacheCallback
    implements Compressor {
        public RemoteCompressor(String desc) {
            super(desc);
        }

        @Override
        public byte[] compress(byte[] input) {
            return null;
        }

        @Override
        public byte[] decompress(byte[] input) {
            return null;
        }
    }

    private static class RemoteCacheLoader
    extends RemoteCacheCallback
    implements CacheLoader {
        public RemoteCacheLoader(String desc) {
            super(desc);
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            return null;
        }
    }

    private static class RemoteCustomExpiry
    extends RemoteCacheCallback
    implements CustomExpiry,
    Declarable {
        public RemoteCustomExpiry(String desc) {
            super(desc);
        }

        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        @Override
        public void init(Properties props) {
        }
    }

    private static class RemoteCacheWriter
    extends RemoteCacheCallback
    implements CacheWriter {
        public RemoteCacheWriter(String desc) {
            super(desc);
        }

        public void beforeUpdate(EntryEvent event) throws CacheWriterException {
        }

        public void beforeCreate(EntryEvent event) throws CacheWriterException {
        }

        public void beforeDestroy(EntryEvent event) throws CacheWriterException {
        }

        public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
        }

        public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
        }
    }

    private static class RemoteCacheListener
    extends RemoteCacheCallback
    implements CacheListener {
        public RemoteCacheListener(String desc) {
            super(desc);
        }

        public void afterCreate(EntryEvent event) {
        }

        public void afterUpdate(EntryEvent event) {
        }

        public void afterInvalidate(EntryEvent event) {
        }

        public void afterDestroy(EntryEvent event) {
        }

        public void afterRegionInvalidate(RegionEvent event) {
        }

        public void afterRegionDestroy(RegionEvent event) {
        }

        public void afterRegionClear(RegionEvent event) {
        }

        public void afterRegionCreate(RegionEvent event) {
        }

        public void afterRegionLive(RegionEvent event) {
        }
    }

    private static abstract class RemoteCacheCallback
    implements CacheCallback {
        private final String desc;

        protected RemoteCacheCallback(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }

        @Override
        public void close() {
        }
    }
}

