/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;

public class RemoteObjectName
implements DataSerializable {
    private static final long serialVersionUID = 5076319310507575418L;
    private String className;
    private String value;
    private int hashCode;

    public RemoteObjectName(Object name) {
        this.className = name.getClass().getName();
        this.value = name.toString();
        this.hashCode = name.hashCode();
    }

    public RemoteObjectName() {
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof RemoteObjectName) {
            RemoteObjectName n = (RemoteObjectName)o;
            return this.hashCode == n.hashCode && this.className.equals(n.className) && this.value.equals(n.value);
        }
        if (this.hashCode != o.hashCode()) {
            return false;
        }
        if (!this.className.equals(o.getClass().getName())) {
            return false;
        }
        return this.value.equals(o.toString());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.className + " \"" + this.value + "\"";
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.className, out);
        DataSerializer.writeString(this.value, out);
        out.writeInt(this.hashCode);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.className = DataSerializer.readString(in);
        this.value = DataSerializer.readString(in);
        this.hashCode = in.readInt();
    }
}

