/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SystemTimer {
    private static final Logger logger = LogService.getLogger();
    private static final boolean isIBM = "IBM Corporation".equals(System.getProperty("java.vm.vendor"));
    private final Timer timer = new Timer(true);
    private volatile boolean cancelled = false;
    private final DistributedSystem distributedSystem;
    @MakeNotStatic
    private static final HashMap<DistributedSystem, Set<WeakReference<SystemTimer>>> distributedSystemTimers = new HashMap();
    @MakeNotStatic
    private static long lastSweepAllTime = 0L;
    private static final long SWEEP_ALL_INTERVAL = 120000L;

    public String toString() {
        return "SystemTimer[system = " + this.distributedSystem + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTimer(DistributedSystem system, SystemTimer systemTimer) {
        Set<WeakReference<SystemTimer>> timers;
        HashMap<DistributedSystem, Set<WeakReference<SystemTimer>>> hashMap = distributedSystemTimers;
        synchronized (hashMap) {
            timers = distributedSystemTimers.get(system);
            if (timers == null) {
                timers = new HashSet<WeakReference<SystemTimer>>();
                distributedSystemTimers.put(system, timers);
            }
        }
        WeakReference<SystemTimer> wr = new WeakReference<SystemTimer>(systemTimer);
        Set<WeakReference<SystemTimer>> set = timers;
        synchronized (set) {
            timers.add(wr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int distributedSystemCount() {
        HashMap<DistributedSystem, Set<WeakReference<SystemTimer>>> hashMap = distributedSystemTimers;
        synchronized (hashMap) {
            return distributedSystemTimers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sweepAllTimers() {
        if (System.currentTimeMillis() < lastSweepAllTime + 120000L) {
            return;
        }
        boolean isDebugEnabled = logger.isTraceEnabled();
        HashMap<DistributedSystem, Set<WeakReference<SystemTimer>>> hashMap = distributedSystemTimers;
        synchronized (hashMap) {
            Iterator<Map.Entry<DistributedSystem, Set<WeakReference<SystemTimer>>>> allSystemsIterator = distributedSystemTimers.entrySet().iterator();
            while (allSystemsIterator.hasNext()) {
                Set<WeakReference<SystemTimer>> timers;
                Map.Entry<DistributedSystem, Set<WeakReference<SystemTimer>>> entry = allSystemsIterator.next();
                Set<WeakReference<SystemTimer>> set = timers = entry.getValue();
                synchronized (set) {
                    Iterator<WeakReference<SystemTimer>> timersIterator = timers.iterator();
                    while (timersIterator.hasNext()) {
                        WeakReference<SystemTimer> wr = timersIterator.next();
                        SystemTimer st = (SystemTimer)wr.get();
                        if (st != null && !st.isCancelled()) continue;
                        timersIterator.remove();
                    }
                    if (timers.size() == 0) {
                        allSystemsIterator.remove();
                    }
                }
            }
        }
        lastSweepAllTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTimer(SystemTimer timerToRemove) {
        HashMap<DistributedSystem, Set<WeakReference<SystemTimer>>> hashMap = distributedSystemTimers;
        synchronized (hashMap) {
            Set<WeakReference<SystemTimer>> timers = distributedSystemTimers.get(timerToRemove.distributedSystem);
            if (timers == null) {
                return;
            }
            Set<WeakReference<SystemTimer>> set = timers;
            synchronized (set) {
                Iterator<WeakReference<SystemTimer>> timersIterator = timers.iterator();
                while (timersIterator.hasNext()) {
                    WeakReference<SystemTimer> ref = timersIterator.next();
                    SystemTimer timer = (SystemTimer)ref.get();
                    if (timer == null) {
                        timersIterator.remove();
                        continue;
                    }
                    if (timer == timerToRemove) {
                        timersIterator.remove();
                        break;
                    }
                    if (!timer.isCancelled()) continue;
                    timersIterator.remove();
                }
                if (timers.size() == 0) {
                    distributedSystemTimers.remove(timerToRemove.distributedSystem);
                }
            }
        }
        SystemTimer.sweepAllTimers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelTimers(DistributedSystem system) {
        Set<WeakReference<SystemTimer>> timers;
        Object object = distributedSystemTimers;
        synchronized (object) {
            timers = distributedSystemTimers.get(system);
            if (timers == null) {
                return;
            }
            distributedSystemTimers.remove(system);
        }
        object = timers;
        synchronized (object) {
            for (WeakReference<SystemTimer> wr : timers) {
                SystemTimer st = (SystemTimer)wr.get();
                if (st == null) continue;
                st.cancelled = true;
                st.timer.cancel();
            }
        }
    }

    public int timerPurge() {
        if (isIBM) {
            return 0;
        }
        return this.timer.purge();
    }

    public SystemTimer(DistributedSystem distributedSystem) {
        this.distributedSystem = distributedSystem;
        SystemTimer.addTimer(distributedSystem, this);
    }

    private void checkCancelled() throws IllegalStateException {
        if (this.cancelled) {
            throw new IllegalStateException("This timer has been cancelled.");
        }
    }

    public void schedule(SystemTimerTask task, long delay) {
        this.checkCancelled();
        this.timer.schedule((TimerTask)task, delay);
    }

    public void schedule(SystemTimerTask task, Date time) {
        this.checkCancelled();
        this.timer.schedule((TimerTask)task, time);
    }

    public void scheduleAtFixedRate(SystemTimerTask task, long delay, long period) {
        this.checkCancelled();
        this.timer.scheduleAtFixedRate((TimerTask)task, delay, period);
    }

    public void schedule(SystemTimerTask task, long delay, long period) {
        this.checkCancelled();
        this.timer.schedule((TimerTask)task, delay, period);
    }

    public void cancel() {
        this.cancelled = true;
        this.timer.cancel();
        SystemTimer.removeTimer(this);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static abstract class SystemTimerTask
    extends TimerTask {
        protected static final Logger logger = LogService.getLogger();
        private volatile boolean cancelled;

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean cancel() {
            this.cancelled = true;
            return super.cancel();
        }

        public abstract void run2();

        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (CancelException cancelException) {
            }
            catch (Throwable t) {
                logger.warn(String.format("Timer task <%s> encountered exception", this), t);
            }
        }
    }
}

