/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.internal.PdxString;

public class QueryExecutionContext
extends ExecutionContext {
    private int nextFieldNum = 0;
    private final Query query;
    private final boolean cqQueryContext;
    private List bucketList;
    private boolean indexUsed = false;
    private final Stack execCacheStack = new Stack();
    private final Map execCaches = new HashMap();
    private Map<Integer, PdxString> bindArgumentToPdxStringMap;
    private ArrayList hints = null;

    public QueryExecutionContext(Object[] bindArguments, InternalCache cache) {
        super(bindArguments, cache);
        this.query = null;
        this.cqQueryContext = false;
    }

    public QueryExecutionContext(Object[] bindArguments, InternalCache cache, boolean cqQueryContext) {
        super(bindArguments, cache);
        this.query = null;
        this.cqQueryContext = cqQueryContext;
    }

    public QueryExecutionContext(Object[] bindArguments, InternalCache cache, Query query) {
        super(bindArguments, cache);
        this.query = query;
        this.cqQueryContext = ((DefaultQuery)query).isCqQuery();
    }

    @Override
    void cachePut(Object key, Object value) {
        HashMap<Object, Object> execCache;
        if (key.equals("query_index_hints")) {
            this.setHints((ArrayList)value);
            return;
        }
        int scopeId = -1;
        if (!this.execCacheStack.isEmpty()) {
            scopeId = (Integer)this.execCacheStack.peek();
        }
        if ((execCache = (HashMap<Object, Object>)this.execCaches.get(scopeId)) == null) {
            execCache = new HashMap<Object, Object>();
            this.execCaches.put(scopeId, execCache);
        }
        execCache.put(key, value);
    }

    @Override
    public Object cacheGet(Object key) {
        return this.cacheGet(key, null);
    }

    @Override
    public Object cacheGet(Object key, Object defaultValue) {
        Map execCache;
        int scopeId = -1;
        if (!this.execCacheStack.isEmpty()) {
            scopeId = (Integer)this.execCacheStack.peek();
        }
        if ((execCache = (Map)this.execCaches.get(scopeId)) == null) {
            return defaultValue;
        }
        if (execCache.containsKey(key)) {
            return execCache.get(key);
        }
        return defaultValue;
    }

    @Override
    public void pushExecCache(int scopeNum) {
        this.execCacheStack.push(scopeNum);
    }

    @Override
    public void popExecCache() {
        this.execCacheStack.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.execCacheStack.clear();
    }

    @Override
    int nextFieldNum() {
        return this.nextFieldNum++;
    }

    @Override
    public boolean isCqQueryContext() {
        return this.cqQueryContext;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setBucketList(List list) {
        this.bucketList = list;
    }

    @Override
    public List getBucketList() {
        return this.bucketList;
    }

    @Override
    public PdxString getSavedPdxString(int index) {
        PdxString pdxString;
        if (this.bindArgumentToPdxStringMap == null) {
            this.bindArgumentToPdxStringMap = new HashMap<Integer, PdxString>();
        }
        if ((pdxString = this.bindArgumentToPdxStringMap.get(index - 1)) == null) {
            pdxString = new PdxString((String)this.bindArguments[index - 1]);
            this.bindArgumentToPdxStringMap.put(index - 1, pdxString);
        }
        return pdxString;
    }

    public boolean isIndexUsed() {
        return this.indexUsed;
    }

    void setIndexUsed(boolean indexUsed) {
        this.indexUsed = indexUsed;
    }

    private void setHints(ArrayList<String> hints) {
        this.hints = new ArrayList();
        this.hints.addAll(hints);
    }

    public boolean isHinted(String indexName) {
        return this.hints != null && this.hints.contains(indexName);
    }

    public int getHintSize(String indexName) {
        return -(this.hints.size() - this.hints.indexOf(indexName));
    }

    boolean hasHints() {
        return this.hints != null;
    }

    boolean hasMultiHints() {
        return this.hints != null && this.hints.size() > 1;
    }
}

