/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.List;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.LinkedResultSet;
import org.apache.geode.cache.query.internal.LinkedStructSet;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;

class IndexCutDownExpansionHelper {
    boolean cutDownNeeded = false;
    SelectResults checkSet = null;
    ObjectType checkType = null;
    int checkSize = -1;

    IndexCutDownExpansionHelper(List checkList, ExecutionContext context) {
        boolean bl = this.cutDownNeeded = checkList != null && (this.checkSize = checkList.size()) > 0;
        if (this.cutDownNeeded) {
            Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
            boolean useLinkedDataStructure = false;
            boolean nullValuesAtStart = true;
            if (orderByClause != null && orderByClause.booleanValue()) {
                List orderByAttrs = (List)context.cacheGet("orderby");
                useLinkedDataStructure = orderByAttrs.size() == 1;
                boolean bl2 = nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
            }
            if (this.checkSize > 1) {
                this.checkType = QueryUtils.createStructTypeForRuntimeIterators(checkList);
                this.checkSet = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)this.checkType) : new SortedResultsBag(this.checkType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)this.checkType);
            } else {
                this.checkType = ((RuntimeIterator)checkList.get(0)).getElementType();
                this.checkSet = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(this.checkType) : new SortedResultsBag(this.checkType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, this.checkType);
            }
        }
    }
}

