/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.Serializable;
import javax.print.attribute.EnumSyntax;
import org.apache.geode.annotations.Immutable;

@Immutable
public final class EvictionAlgorithm
extends EnumSyntax
implements Serializable {
    private static final long serialVersionUID = 5778669432033106789L;
    @Immutable
    public static final EvictionAlgorithm NONE = new EvictionAlgorithm(0);
    @Immutable
    public static final EvictionAlgorithm LRU_ENTRY = new EvictionAlgorithm(1);
    @Immutable
    public static final EvictionAlgorithm LRU_HEAP = new EvictionAlgorithm(2);
    @Immutable
    public static final EvictionAlgorithm LRU_MEMORY = new EvictionAlgorithm(3);
    @Deprecated
    @Immutable
    public static final EvictionAlgorithm LIFO_ENTRY = new EvictionAlgorithm(4);
    @Deprecated
    @Immutable
    public static final EvictionAlgorithm LIFO_MEMORY = new EvictionAlgorithm(5);
    private static final String[] stringTable = new String[]{"none", "lru-entry-count", "lru-heap-percentage", "lru-memory-size", "lifo-entry-count", "lifo-memory-size"};
    @Immutable
    private static final EvictionAlgorithm[] enumValueTable = new EvictionAlgorithm[]{NONE, LRU_ENTRY, LRU_HEAP, LRU_MEMORY, LIFO_ENTRY, LIFO_MEMORY};

    private EvictionAlgorithm(int val) {
        super(val);
    }

    @Override
    protected String[] getStringTable() {
        return stringTable;
    }

    @Override
    protected EnumSyntax[] getEnumValueTable() {
        return enumValueTable;
    }

    public static EvictionAlgorithm parseValue(int v) {
        if (v < 0 || v >= enumValueTable.length) {
            return null;
        }
        return enumValueTable[v];
    }

    public static EvictionAlgorithm parseAction(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 1) {
            return null;
        }
        for (int i = 0; i < stringTable.length; ++i) {
            if (!s.equals(stringTable[i])) continue;
            return enumValueTable[i];
        }
        return null;
    }

    public boolean isLRUEntry() {
        return this == LRU_ENTRY;
    }

    public boolean isLRUMemory() {
        return this == LRU_MEMORY;
    }

    public boolean isLRUHeap() {
        return this == LRU_HEAP;
    }

    public boolean isLRU() {
        return this.isLRUEntry() || this.isLRUMemory() || this.isLRUHeap();
    }

    public boolean isNone() {
        return this == NONE;
    }

    @Deprecated
    public boolean isLIFO() {
        return this == LIFO_ENTRY || this == LIFO_MEMORY;
    }
}

