/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal.log4j;

import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.logging.log4j.Level;

public class AlertLevelConverter {
    public static boolean hasAlertLevel(Level level) {
        if (level == Level.FATAL) {
            return true;
        }
        if (level == Level.ERROR) {
            return true;
        }
        if (level == Level.WARN) {
            return true;
        }
        return level == Level.OFF;
    }

    public static Level toLevel(AlertLevel alert) {
        switch (alert) {
            case SEVERE: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARNING: {
                return Level.WARN;
            }
            case NONE: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("No matching Log4J2 Level for " + (Object)((Object)alert) + ".");
    }

    public static AlertLevel fromLevel(Level level) {
        if (level == Level.FATAL) {
            return AlertLevel.SEVERE;
        }
        if (level == Level.ERROR) {
            return AlertLevel.ERROR;
        }
        if (level == Level.WARN) {
            return AlertLevel.WARNING;
        }
        if (level == Level.OFF) {
            return AlertLevel.NONE;
        }
        throw new IllegalArgumentException("No matching AlertLevel for Log4J2 Level " + level + ".");
    }
}

