/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Filter;

public class MessageBatch
implements Iterable<Message> {
    protected Address dest;
    protected Address sender;
    protected AsciiString cluster_name;
    protected Message[] messages;
    protected int index;
    protected boolean multicast;
    protected Mode mode = Mode.REG;
    protected static final int INCR = 5;

    public MessageBatch(int capacity) {
        this.messages = new Message[capacity];
    }

    public MessageBatch(Collection<Message> msgs) {
        this.messages = new Message[msgs.size()];
        for (Message msg : msgs) {
            this.messages[this.index++] = msg;
        }
        this.mode = this.determineMode();
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Collection<Message> msgs) {
        this(dest, sender, cluster_name, multicast, msgs, null);
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Collection<Message> msgs, Filter<Message> filter) {
        this.messages = new Message[msgs.size()];
        for (Message msg : msgs) {
            if (filter != null && !filter.accept(msg)) continue;
            this.messages[this.index++] = msg;
        }
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.mode = this.determineMode();
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Mode mode, int capacity) {
        this(capacity);
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.mode = mode;
    }

    public Address dest() {
        return this.dest;
    }

    public MessageBatch dest(Address dest) {
        this.dest = dest;
        return this;
    }

    public Address sender() {
        return this.sender;
    }

    public MessageBatch sender(Address sender) {
        this.sender = sender;
        return this;
    }

    public AsciiString clusterName() {
        return this.cluster_name;
    }

    public MessageBatch clusterName(AsciiString name) {
        this.cluster_name = name;
        return this;
    }

    public boolean multicast() {
        return this.multicast;
    }

    public Mode mode() {
        return this.mode;
    }

    public MessageBatch mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public int capacity() {
        return this.messages.length;
    }

    public Message[] array() {
        return this.messages;
    }

    public Message first() {
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            return this.messages[i];
        }
        return null;
    }

    public Message last() {
        for (int i = this.index - 1; i >= 0; --i) {
            if (this.messages[i] == null) continue;
            return this.messages[i];
        }
        return null;
    }

    public MessageBatch add(Message msg) {
        if (msg == null) {
            return this;
        }
        if (this.index >= this.messages.length) {
            this.resize();
        }
        this.messages[this.index++] = msg;
        return this;
    }

    public MessageBatch replace(Message existing_msg, Message new_msg) {
        if (existing_msg == null) {
            return this;
        }
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null || this.messages[i] != existing_msg) continue;
            this.messages[i] = new_msg;
            break;
        }
        return this;
    }

    public MessageBatch replace(Filter<Message> filter, Message replacement, boolean match_all) {
        if (filter == null) {
            return this;
        }
        for (int i = 0; i < this.index; ++i) {
            if (!filter.accept(this.messages[i])) continue;
            this.messages[i] = replacement;
            if (!match_all) break;
        }
        return this;
    }

    public MessageBatch remove(Message msg) {
        return this.replace(msg, null);
    }

    public MessageBatch remove(Filter<Message> filter) {
        return this.replace(filter, null, true);
    }

    public MessageBatch clear() {
        for (int i = 0; i < this.index; ++i) {
            this.messages[i] = null;
        }
        this.index = 0;
        return this;
    }

    public Collection<Message> getMatchingMessages(final short id, final boolean remove) {
        return this.map(new Visitor<Message>(){

            @Override
            public Message visit(Message msg, MessageBatch batch) {
                if (msg != null && msg.getHeader(id) != null) {
                    if (remove) {
                        batch.remove(msg);
                    }
                    return msg;
                }
                return null;
            }
        });
    }

    public <T> Collection<T> map(Visitor<T> visitor) {
        ArrayList<T> retval = null;
        for (int i = 0; i < this.index; ++i) {
            try {
                T result = visitor.visit(this.messages[i], this);
                if (result == null) continue;
                if (retval == null) {
                    retval = new ArrayList<T>();
                }
                retval.add(result);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retval;
    }

    public int size() {
        int retval = 0;
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            ++retval;
        }
        return retval;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            return false;
        }
        return true;
    }

    public Mode determineMode() {
        int num_oob = 0;
        int num_reg = 0;
        int num_internal = 0;
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            if (this.messages[i].isFlagSet(Message.Flag.OOB)) {
                ++num_oob;
                continue;
            }
            if (this.messages[i].isFlagSet(Message.Flag.INTERNAL)) {
                ++num_internal;
                continue;
            }
            ++num_reg;
        }
        if (num_internal > 0 && num_oob == 0 && num_reg == 0) {
            return Mode.INTERNAL;
        }
        if (num_oob > 0 && num_internal == 0 && num_reg == 0) {
            return Mode.OOB;
        }
        if (num_reg > 0 && num_oob == 0 && num_internal == 0) {
            return Mode.REG;
        }
        return Mode.MIXED;
    }

    public long totalSize() {
        long retval = 0L;
        Visitor<Long> visitor = new Visitor<Long>(){

            @Override
            public Long visit(Message msg, MessageBatch batch) {
                return msg != null ? msg.size() : 0L;
            }
        };
        for (int i = 0; i < this.index; ++i) {
            retval += ((Long)visitor.visit(this.messages[i], this)).longValue();
        }
        return retval;
    }

    public int length() {
        int retval = 0;
        Visitor<Integer> visitor = new Visitor<Integer>(){

            @Override
            public Integer visit(Message msg, MessageBatch batch) {
                return msg != null ? msg.getLength() : 0;
            }
        };
        for (int i = 0; i < this.index; ++i) {
            retval += ((Integer)visitor.visit(this.messages[i], this)).intValue();
        }
        return retval;
    }

    @Override
    public Iterator<Message> iterator() {
        return new BatchIterator(this.index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        sb.append(", mode=" + (Object)((Object)this.mode));
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(this.size() + " messages [capacity=" + this.messages.length + "]");
        return sb.toString();
    }

    public String printHeaders() {
        StringBuilder sb = new StringBuilder().append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        sb.append("\n").append(this.size()).append(":\n");
        int count = 1;
        for (Message msg : this) {
            sb.append("#").append(count++).append(": ").append(msg.printHeaders()).append("\n");
        }
        return sb.toString();
    }

    protected void resize() {
        Message[] tmp = new Message[this.messages.length + 5];
        System.arraycopy(this.messages, 0, tmp, 0, this.messages.length);
        this.messages = tmp;
    }

    protected class BatchIterator
    implements Iterator<Message> {
        protected int current_index = -1;
        protected final int saved_index;

        public BatchIterator(int saved_index) {
            this.saved_index = saved_index;
        }

        @Override
        public boolean hasNext() {
            while (this.current_index + 1 < this.saved_index && MessageBatch.this.messages[this.current_index + 1] == null) {
                ++this.current_index;
            }
            return this.current_index + 1 < this.saved_index;
        }

        @Override
        public Message next() {
            if (this.current_index + 1 >= MessageBatch.this.messages.length) {
                throw new NoSuchElementException();
            }
            return MessageBatch.this.messages[++this.current_index];
        }

        @Override
        public void remove() {
            if (this.current_index >= 0) {
                MessageBatch.this.messages[this.current_index] = null;
            }
        }
    }

    public static enum Mode {
        OOB,
        REG,
        INTERNAL,
        MIXED;

    }

    public static interface Visitor<T> {
        public T visit(Message var1, MessageBatch var2);
    }
}

