/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.GZIPRemoteInputStream;
import com.healthmarketscience.rmiio.PacketInputStream;
import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.RmiioUtil;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectRemoteInputStream
implements RemoteInputStream,
Closeable,
Serializable {
    private static final Log LOG = LogFactory.getLog(DirectRemoteInputStream.class);
    private static final long serialVersionUID = 20080125L;
    private static final int DEFAULT_CHUNK_CODE = 0;
    private static final int CUSTOM_CHUNK_CODE = 1;
    private static final int EOF_CODE = 2;
    private transient InputStream _in;
    private transient RemoteStreamMonitor<RemoteInputStreamServer> _monitor;
    private transient ConsumptionState _consumptionState;
    private transient boolean _gotEOF;
    private transient File _tmpFile;
    private final boolean _compress;

    public DirectRemoteInputStream(InputStream in) {
        this(in, true, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public DirectRemoteInputStream(InputStream in, boolean compress) {
        this(in, compress, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public DirectRemoteInputStream(InputStream in, boolean compress, RemoteStreamMonitor<RemoteInputStreamServer> monitor) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this._in = in;
        this._compress = compress;
        this._monitor = monitor;
        this._consumptionState = ConsumptionState.NONE;
    }

    private void markLocalConsumption() {
        if (this._consumptionState == ConsumptionState.SERIAL) {
            throw new IllegalStateException("locally consuming stream which was already serialized");
        }
        this._consumptionState = ConsumptionState.LOCAL;
    }

    @Override
    public boolean usingGZIPCompression() throws IOException, RemoteException {
        return this._compress;
    }

    @Override
    public int available() throws IOException, RemoteException {
        this.markLocalConsumption();
        return this._in.available();
    }

    @Override
    public void close(boolean readSuccess) throws IOException, RemoteException {
        this.close();
    }

    @Override
    public byte[] readPacket(int packetId) throws IOException, RemoteException {
        if (this._gotEOF) {
            return null;
        }
        this.markLocalConsumption();
        byte[] packet = PacketInputStream.readPacket(this._in, new byte[7168]);
        this._gotEOF = packet == null;
        return packet;
    }

    @Override
    public long skip(long n, int skipId) throws IOException, RemoteException {
        this.markLocalConsumption();
        return this._in.skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this._consumptionState == ConsumptionState.NONE) {
            this._consumptionState = ConsumptionState.LOCAL;
        }
        try {
            if (this._in != null) {
                this._in.close();
            }
        }
        finally {
            this._in = null;
            this._gotEOF = true;
            if (this._tmpFile != null) {
                this._tmpFile.delete();
                this._tmpFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        switch (this._consumptionState) {
            case NONE: {
                break;
            }
            case LOCAL: 
            case SERIAL: {
                throw new NotSerializableException(this.getClass().getName() + " (underlying stream has already been consumed, type: " + (Object)((Object)this._consumptionState) + ")");
            }
            default: {
                throw new RuntimeException("unknown state " + (Object)((Object)this._consumptionState));
            }
        }
        out.defaultWriteObject();
        this._consumptionState = ConsumptionState.SERIAL;
        int defaultChunkSize = 7168;
        RemoteInputStreamServer server = null;
        try {
            byte[] packet;
            server = this._compress && this._tmpFile == null ? new GZIPRemoteInputStream(this._in, this._monitor, 7168) : new SimpleRemoteInputStream(this._in, this._monitor, 7168);
            out.writeInt(7168);
            int packetId = 0;
            while ((packet = server.readPacket(packetId++)) != null) {
                if (packet.length <= 0) continue;
                if (packet.length == 7168) {
                    out.write(0);
                } else {
                    out.write(1);
                    out.writeInt(packet.length);
                }
                out.write(packet);
            }
            out.write(2);
            this._gotEOF = true;
            try {
                server.close(true);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Failed closing server", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            RmiioUtil.closeQuietly(server);
            RmiioUtil.closeQuietly(this);
            throw throwable;
        }
        RmiioUtil.closeQuietly(server);
        RmiioUtil.closeQuietly(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int defaultChunkSize = in.readInt();
        DirectRemoteInputStream.checkChunkSize(defaultChunkSize);
        this._tmpFile = File.createTempFile("stream_", ".dat");
        this._tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(this._tmpFile);
        try {
            int chunkCode;
            byte[] transferBuf = new byte[Math.min(defaultChunkSize, 7168)];
            while ((chunkCode = in.read()) != 2) {
                int readLen = defaultChunkSize;
                if (chunkCode != 0) {
                    readLen = in.readInt();
                    DirectRemoteInputStream.checkChunkSize(readLen);
                }
                DirectRemoteInputStream.copy(in, out, transferBuf, readLen);
            }
            out.close();
            this._monitor = RemoteInputStreamServer.DUMMY_MONITOR;
            this._in = new BufferedInputStream(new FileInputStream(this._tmpFile));
            this._consumptionState = ConsumptionState.NONE;
            this._gotEOF = false;
        }
        finally {
            RmiioUtil.closeQuietly(out);
        }
    }

    private static void checkChunkSize(int chunkSize) throws IOException {
        if (chunkSize <= 0) {
            throw new InvalidObjectException("invalid chunk size " + chunkSize);
        }
    }

    private static void copy(InputStream in, OutputStream out, byte[] buffer, int length) throws IOException {
        while (length > 0) {
            int readLen = in.read(buffer, 0, Math.min(buffer.length, length));
            if (readLen < 0) {
                throw new InvalidObjectException("input stream data truncated");
            }
            out.write(buffer, 0, readLen);
            length -= readLen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConsumptionState {
        NONE,
        LOCAL,
        SERIAL;

    }
}

