/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.internal.serialization.filter.FilterAlreadyConfiguredException;
import org.apache.geode.internal.serialization.filter.GlobalSerialFilter;
import org.apache.geode.internal.serialization.filter.ObjectInputFilterApi;
import org.apache.geode.internal.serialization.filter.UnableToSetSerialFilterException;

class ReflectiveFacadeGlobalSerialFilter
implements GlobalSerialFilter {
    private final ObjectInputFilterApi api;
    private final String pattern;
    private final Collection<String> sanctionedClasses;

    ReflectiveFacadeGlobalSerialFilter(ObjectInputFilterApi api, String pattern, Collection<String> sanctionedClasses) {
        this.api = Objects.requireNonNull(api, "ObjectInputFilterApi is required");
        this.pattern = pattern;
        this.sanctionedClasses = Collections.unmodifiableCollection(sanctionedClasses);
    }

    @Override
    public void setFilter() throws UnableToSetSerialFilterException {
        try {
            Object objectInputFilter = this.api.createObjectInputFilterProxy(this.pattern, this.sanctionedClasses);
            this.api.setSerialFilter(objectInputFilter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.handleExceptionThrownByApi(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "api=" + this.api + ", pattern='" + this.pattern + '\'' + '}';
    }

    private void handleExceptionThrownByApi(ReflectiveOperationException e) throws UnableToSetSerialFilterException {
        String className;
        switch (className = ReflectiveFacadeGlobalSerialFilter.getClassName(e)) {
            case "java.lang.IllegalAccessException": {
                throw new UnableToSetSerialFilterException("Unable to configure a global serialization filter using reflection.", e);
            }
            case "java.lang.reflect.InvocationTargetException": {
                if (ExceptionUtils.getRootCause(e) instanceof IllegalStateException) {
                    throw new FilterAlreadyConfiguredException("Unable to configure a global serialization filter because filter has already been set non-null.", e);
                }
                String causeClassName = e.getCause() == null ? ReflectiveFacadeGlobalSerialFilter.getClassName(e) : ReflectiveFacadeGlobalSerialFilter.getClassName(e.getCause());
                throw new UnableToSetSerialFilterException("Unable to configure a global serialization filter because invocation target threw " + causeClassName + ".", e);
            }
        }
        throw new UnableToSetSerialFilterException("Unable to configure a global serialization filter.", e);
    }

    private static String getClassName(Throwable throwable) {
        return throwable.getClass().getName();
    }
}

