/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class BytesToString {
    private static final double BYTES_PER_KB = 1024.0;
    private static final double BYTES_PER_MB = 1048576.0;
    private static final double BYTES_PER_GB = 1.073741824E9;
    private static final double BYTES_PER_TB = 1.099511627776E12;

    public String of(long sizeInBytes) {
        DecimalFormat numberFormat = new DecimalFormat();
        ((NumberFormat)numberFormat).setMaximumFractionDigits(2);
        try {
            if ((double)sizeInBytes < 1024.0) {
                return numberFormat.format(sizeInBytes) + " Byte(s)";
            }
            if ((double)sizeInBytes < 1048576.0) {
                return numberFormat.format((double)sizeInBytes / 1024.0) + " KB";
            }
            if ((double)sizeInBytes < 1.073741824E9) {
                return numberFormat.format((double)sizeInBytes / 1048576.0) + " MB";
            }
            if ((double)sizeInBytes < 1.099511627776E12) {
                return numberFormat.format((double)sizeInBytes / 1.073741824E9) + " GB";
            }
            return numberFormat.format((double)sizeInBytes / 1.099511627776E12) + " TB";
        }
        catch (Exception e) {
            return sizeInBytes + " Byte(s)";
        }
    }
}

