/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.converters.BaseStringConverter;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class DiskStoreNameConverter
extends BaseStringConverter {
    @Override
    public String getConverterHint() {
        return "geode.converter.cluster.diskstore:disable-string-converter";
    }

    @Override
    public Set<String> getCompletionValues() {
        Map diskStoreInfo;
        TreeSet<String> diskStoreNames = new TreeSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (diskStoreInfo = gfsh.getOperationInvoker().getDistributedSystemMXBean().listMemberDiskstore()) != null) {
            Set entries = diskStoreInfo.entrySet();
            for (Map.Entry entry : entries) {
                String[] value = (String[])entry.getValue();
                if (value == null) continue;
                diskStoreNames.addAll(Arrays.asList(value));
            }
        }
        return diskStoreNames;
    }
}

