/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.TreeSet;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.Distribution;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListMembersCommand
extends GfshCommand {
    public static final String MEMBERS_SECTION = "members";

    @CliCommand(value={"list members"}, help="Display all or a subset of members.")
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listMember(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group name for which members will be displayed.") String[] groups) {
        ResultModel crm = new ResultModel();
        TreeSet<DistributedMember> memberSet = new TreeSet<DistributedMember>(this.findMembersIncludingLocators(groups, null));
        if (memberSet.isEmpty()) {
            crm.addInfo().addLine("No Members Found");
            return crm;
        }
        crm.addInfo().addLine("Member Count : " + memberSet.size());
        TabularResultModel resultData = crm.addTable(MEMBERS_SECTION);
        String coordinatorMemberId = this.getCoordinatorId();
        for (DistributedMember member : memberSet) {
            resultData.accumulate("Name", member.getName());
            if (member.getUniqueId().equals(coordinatorMemberId)) {
                resultData.accumulate("Id", member.getId() + " [Coordinator]");
                continue;
            }
            resultData.accumulate("Id", member.getId());
        }
        return crm;
    }

    String getCoordinatorId() {
        InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
        if (ids == null || !ids.isConnected()) {
            return null;
        }
        Distribution mmgr = ids.getDistributionManager().getDistribution();
        if (mmgr == null) {
            return null;
        }
        return mmgr.getCoordinator().getUniqueId();
    }
}

