/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

final class TermScorer
extends Scorer {
    private final PostingsEnum postingsEnum;
    private final Similarity.SimScorer docScorer;

    TermScorer(Weight weight, PostingsEnum td, Similarity.SimScorer docScorer) {
        super(weight);
        this.docScorer = docScorer;
        this.postingsEnum = td;
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    @Override
    public int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.postingsEnum;
    }

    @Override
    public float score() throws IOException {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docScorer.score(this.postingsEnum.docID(), this.postingsEnum.freq());
    }

    public String toString() {
        return "scorer(" + this.weight + ")[" + super.toString() + "]";
    }
}

