/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.table;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import org.springframework.shell.support.table.Table;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.shell.support.table.TableRow;
import org.springframework.util.StringUtils;

public final class TableRenderer {
    public static final String HORIZONTAL_LINE = "-------------------------------------------------------------------------------\n";
    public static final int COLUMN_1 = 1;
    public static final int COLUMN_2 = 2;
    public static final int COLUMN_3 = 3;
    public static final int COLUMN_4 = 4;
    public static final int COLUMN_5 = 5;
    public static final int COLUMN_6 = 6;

    private TableRenderer() {
        throw new AssertionError();
    }

    public static String renderMapDataAsTable(List<Map<String, Object>> data, List<String> columns) {
        Table table = new Table();
        int col = 0;
        for (String string : columns) {
            table.getHeaders().put(++col, new TableHeader(string));
            if (col < 6) continue;
            break;
        }
        for (Map map : data) {
            TableRow tableRow = new TableRow();
            for (int i = 0; i < col; ++i) {
                String value = map.get(columns.get(i)).toString();
                table.getHeaders().get(i + 1).updateWidth(value.length());
                tableRow.addValue(i + 1, value);
            }
            table.getRows().add(tableRow);
        }
        return TableRenderer.renderTextTable(table);
    }

    public static String renderParameterInfoDataAsTable(Map<String, String> parameters, boolean withHeader, int lastColumnMaxWidth) {
        Table table = new Table();
        table.getHeaders().put(1, new TableHeader("Parameter"));
        TableHeader tableHeader2 = new TableHeader("Value (Configured or Default)");
        tableHeader2.setMaxWidth(lastColumnMaxWidth);
        table.getHeaders().put(2, tableHeader2);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            TableRow tableRow = new TableRow();
            table.getHeaders().get(1).updateWidth(entry.getKey().length());
            tableRow.addValue(1, entry.getKey());
            int width = entry.getValue() != null ? entry.getValue().length() : 0;
            table.getHeaders().get(2).updateWidth(width);
            tableRow.addValue(2, entry.getValue());
            table.getRows().add(tableRow);
        }
        return TableRenderer.renderTextTable(table, withHeader);
    }

    public static String renderParameterInfoDataAsTable(Map<String, String> parameters) {
        return TableRenderer.renderParameterInfoDataAsTable(parameters, true, -1);
    }

    public static String renderTextTable(Table table) {
        return TableRenderer.renderTextTable(table, true);
    }

    public static String renderTextTable(Table table, boolean withHeader) {
        table.calculateColumnWidths();
        String padding = "  ";
        String headerBorder = TableRenderer.getHeaderBorder(table.getHeaders());
        StringBuilder textTable = new StringBuilder();
        if (withHeader) {
            StringBuilder headerline = new StringBuilder();
            for (TableHeader header : table.getHeaders().values()) {
                if (header.getName().length() > header.getWidth()) {
                    Iterable chunks = Splitter.fixedLength((int)header.getWidth()).split((CharSequence)header.getName());
                    int length = headerline.length();
                    boolean first = true;
                    for (String chunk : chunks) {
                        String lineToAppend = first ? "  " + org.springframework.shell.support.util.StringUtils.padRight(chunk, header.getWidth()) : org.springframework.shell.support.util.StringUtils.padLeft("", length) + "  " + org.springframework.shell.support.util.StringUtils.padRight(chunk, header.getWidth());
                        first = false;
                        headerline.append(lineToAppend);
                        headerline.append("\n");
                    }
                    headerline.deleteCharAt(headerline.lastIndexOf("\n"));
                    continue;
                }
                String lineToAppend = "  " + org.springframework.shell.support.util.StringUtils.padRight(header.getName(), header.getWidth());
                headerline.append(lineToAppend);
            }
            textTable.append(StringUtils.trimTrailingWhitespace((String)headerline.toString()));
            textTable.append("\n");
        }
        textTable.append(headerBorder);
        for (TableRow row : table.getRows()) {
            StringBuilder rowLine = new StringBuilder();
            for (Map.Entry<Integer, TableHeader> entry : table.getHeaders().entrySet()) {
                String value = row.getValue(entry.getKey());
                if (value.length() > entry.getValue().getWidth()) {
                    Iterable chunks = Splitter.fixedLength((int)entry.getValue().getWidth()).split((CharSequence)value);
                    int length = rowLine.length();
                    boolean first = true;
                    for (String chunk : chunks) {
                        String lineToAppend = first ? "  " + org.springframework.shell.support.util.StringUtils.padRight(chunk, entry.getValue().getWidth()) : org.springframework.shell.support.util.StringUtils.padLeft("", length) + "  " + org.springframework.shell.support.util.StringUtils.padRight(chunk, entry.getValue().getWidth());
                        first = false;
                        rowLine.append(lineToAppend);
                        rowLine.append("\n");
                    }
                    rowLine.deleteCharAt(rowLine.lastIndexOf("\n"));
                    continue;
                }
                String lineToAppend = "  " + org.springframework.shell.support.util.StringUtils.padRight(value, entry.getValue().getWidth());
                rowLine.append(lineToAppend);
            }
            textTable.append(StringUtils.trimTrailingWhitespace((String)rowLine.toString()));
            textTable.append("\n");
        }
        if (!withHeader) {
            textTable.append(headerBorder);
        }
        return textTable.toString();
    }

    public static String getHeaderBorder(Map<Integer, TableHeader> headers) {
        StringBuilder headerBorder = new StringBuilder();
        for (TableHeader header : headers.values()) {
            headerBorder.append(org.springframework.shell.support.util.StringUtils.padRight("  ", header.getWidth() + 2, '-'));
        }
        headerBorder.append("\n");
        return headerBorder.toString();
    }
}

