/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import mx4j.tools.adaptor.http.HttpInputStream;

public class HttpUtil {
    public static String getCodeMessage(int code) {
        switch (code) {
            case 200: {
                return "OK";
            }
            case 204: {
                return "No Content";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 400: {
                return "Bad Request";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 401: {
                return "Authentication requested";
            }
            case 501: {
                return "Not Implemented";
            }
        }
        return "Unknown Code (" + code + ")";
    }

    public static String canonicalizePath(String path) {
        int idx;
        char[] chars = path.toCharArray();
        int length = chars.length;
        int odx = 0;
        while ((idx = HttpUtil.indexOf(chars, length, '/', odx)) < length - 1) {
            int ndx = HttpUtil.indexOf(chars, length, '/', idx + 1);
            int kill = -1;
            if (ndx == idx + 1) {
                kill = 1;
            } else if (ndx >= idx + 2 && chars[idx + 1] == '.') {
                if (ndx == idx + 2) {
                    kill = 2;
                } else if (ndx == idx + 3 && chars[idx + 2] == '.') {
                    kill = 3;
                    while (idx > 0 && chars[--idx] != '/') {
                        ++kill;
                    }
                }
            }
            if (kill == -1) {
                odx = ndx;
                continue;
            }
            if (idx + kill >= length) {
                length = odx = idx + 1;
                continue;
            }
            System.arraycopy(chars, idx + 1 + kill, chars, idx + 1, (length -= kill) - idx - 1);
            odx = idx;
        }
        return new String(chars, 0, length);
    }

    protected static int indexOf(char[] chars, int length, char chr, int from) {
        while (from < length && chars[from] != chr) {
            ++from;
        }
        return from;
    }

    public static boolean booleanVariableValue(HttpInputStream in, String variable, boolean defaultValue) {
        if (in.getVariables().containsKey(variable)) {
            String result = (String)in.getVariables().get(variable);
            return result.equals("true") || result.equals("1");
        }
        return defaultValue;
    }
}

