/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal.client.locator;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import org.apache.geode.cache.wan.internal.client.locator.LocatorHelper;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LocatorDiscovery {
    private static final Logger logger = LogService.getLogger();
    private final WanLocatorDiscoverer discoverer;
    private final DistributionLocatorId locatorId;
    private final LocatorMembershipListener locatorListener;
    RemoteLocatorJoinRequest request;
    TcpClient locatorClient;
    public static final int WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT = Integer.getInteger("WANLocator.CONNECTION_RETRY_ATTEMPT", 50000);
    public static final int WAN_LOCATOR_CONNECTION_INTERVAL = Integer.getInteger("WANLocator.CONNECTION_INTERVAL", 10000);
    public static final int WAN_LOCATOR_PING_INTERVAL = Integer.getInteger("WANLocator.PING_INTERVAL", 10000);
    private final boolean skipWaiting;
    private final ConcurrentHashMap<DistributionLocatorId, long[]> failureLogInterval = new ConcurrentHashMap();
    private static final int FAILURE_MAP_MAXSIZE = Integer.getInteger("gemfire.GatewaySender.FAILURE_MAP_MAXSIZE", 1000000);
    private static final int FAILURE_LOG_MAX_INTERVAL = Integer.getInteger("gemfire.LocatorDiscovery.FAILURE_LOG_MAX_INTERVAL", 300000);

    public LocatorDiscovery(WanLocatorDiscoverer discoverer, DistributionLocatorId locator, RemoteLocatorJoinRequest request, LocatorMembershipListener locatorListener) {
        this.discoverer = discoverer;
        this.locatorId = locator;
        this.request = request;
        this.locatorListener = locatorListener;
        this.locatorClient = new TcpClient(SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT);
        this.skipWaiting = false;
    }

    @VisibleForTesting
    LocatorDiscovery(WanLocatorDiscoverer discoverer, DistributionLocatorId locator, RemoteLocatorJoinRequest request, LocatorMembershipListener locatorListener, TcpClient locatorClient) {
        this.discoverer = discoverer;
        this.locatorId = locator;
        this.request = request;
        this.locatorListener = locatorListener;
        this.locatorClient = locatorClient;
        this.skipWaiting = true;
    }

    public boolean skipFailureLogging(DistributionLocatorId locatorId) {
        boolean skipLogging = false;
        if (this.failureLogInterval.size() < FAILURE_MAP_MAXSIZE) {
            long[] logInterval = this.failureLogInterval.get(locatorId);
            if (logInterval == null) {
                logInterval = this.failureLogInterval.putIfAbsent(locatorId, new long[]{System.currentTimeMillis(), 1000L});
            }
            if (logInterval != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - logInterval[0] < logInterval[1]) {
                    skipLogging = true;
                } else {
                    logInterval[0] = currentTime;
                    if (logInterval[1] <= (long)(FAILURE_LOG_MAX_INTERVAL / 2)) {
                        logInterval[1] = logInterval[1] * 2L;
                    }
                }
            }
        }
        return skipLogging;
    }

    private void exchangeLocalLocators() {
        int retryAttempt = 1;
        while (!this.discoverer.isStopped()) {
            try {
                RemoteLocatorJoinResponse response = (RemoteLocatorJoinResponse)this.locatorClient.requestToServer(this.locatorId.getHost(), this.request, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                if (response == null) continue;
                this.addExchangedLocators(response);
                logger.info("Locator discovery task for locator {} exchanged locator information with {}: {}.", (Object)this.request.getLocator().marshalForClients(), (Object)this.locatorId.marshalForClients(), (Object)response.getLocators());
                break;
            }
            catch (IOException ioe) {
                if (retryAttempt == WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT) {
                    ConnectionException coe = new ConnectionException("Not able to connect to local locator after " + WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT + " retry attempts", ioe);
                    logger.fatal("Locator discovery task for locator {} could not exchange locator information with {} after {} retry attempts.", (Object)this.request.getLocator().marshalForClients(), (Object)this.locatorId.marshalForClients(), (Object)retryAttempt, (Object)coe);
                    break;
                }
                if (this.skipFailureLogging(this.locatorId)) {
                    logger.warn("Locator discovery task for locator {} could not exchange locator information with {} after {} retry attempts. Retrying in {} ms.", (Object)this.request.getLocator().marshalForClients(), (Object)this.locatorId.marshalForClients(), (Object)retryAttempt, (Object)WAN_LOCATOR_CONNECTION_INTERVAL);
                }
                try {
                    if (!this.skipWaiting) {
                        Thread.sleep(WAN_LOCATOR_CONNECTION_INTERVAL);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++retryAttempt;
            }
            catch (ClassCastException | ClassNotFoundException ex) {
                logger.fatal("Locator discovery task encountered unexpected exception", (Throwable)ex);
                break;
            }
        }
    }

    public void exchangeRemoteLocators() {
        int retryAttempt = 1;
        block6: while (!this.discoverer.isStopped()) {
            try {
                RemoteLocatorJoinResponse response = (RemoteLocatorJoinResponse)this.locatorClient.requestToServer(this.locatorId.getHost(), this.request, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                if (response == null) continue;
                this.addExchangedLocators(response);
                logger.info("Locator discovery task for locator {} exchanged locator information with {}: {}.", (Object)this.request.getLocator().marshalForClients(), (Object)this.locatorId.marshalForClients(), (Object)response.getLocators());
                RemoteLocatorPingRequest pingRequest = new RemoteLocatorPingRequest("");
                while (true) {
                    RemoteLocatorPingResponse pingResponse;
                    if (!this.skipWaiting) {
                        Thread.sleep(WAN_LOCATOR_PING_INTERVAL);
                    }
                    if ((pingResponse = (RemoteLocatorPingResponse)this.locatorClient.requestToServer(new HostAndPort(this.locatorId.getHostName(), this.locatorId.getPort()), pingRequest, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true)) == null) continue block6;
                }
            }
            catch (IOException ioe) {
                if (retryAttempt == WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT) {
                    logger.fatal("Locator discovery task for locator {} could not exchange locator information with {} after {} retry attempts.", (Object)this.request.getLocator().marshalForClients(), (Object)this.locatorId.marshalForClients(), (Object)retryAttempt, (Object)ioe);
                    break;
                }
                if (this.skipFailureLogging(this.locatorId)) {
                    logger.warn("Locator discovery task for locator {} could not exchange locator information with {} after {} retry attempts. Retrying in {} ms.", (Object)this.request.getLocator().marshalForClients(), (Object)this.locatorId.marshalForClients(), (Object)retryAttempt, (Object)WAN_LOCATOR_CONNECTION_INTERVAL);
                }
                try {
                    if (!this.skipWaiting) {
                        Thread.sleep(WAN_LOCATOR_CONNECTION_INTERVAL);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++retryAttempt;
            }
            catch (ClassCastException | ClassNotFoundException ex) {
                logger.fatal("Locator discovery task encountered unexpected exception", (Throwable)ex);
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    void addExchangedLocators(RemoteLocatorJoinResponse response) {
        LocatorHelper.addExchangedLocators(response.getLocators(), this.locatorListener);
    }

    public class RemoteLocatorDiscovery
    implements Runnable {
        @Override
        public void run() {
            LocatorDiscovery.this.exchangeRemoteLocators();
        }
    }

    public class LocalLocatorDiscovery
    implements Runnable {
        @Override
        public void run() {
            LocatorDiscovery.this.exchangeLocalLocators();
        }
    }
}

