/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.WanCopyRegionFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class WanCopyRegionCommand
extends GfshCommand {
    private final WanCopyRegionFunction wanCopyRegionFunction = new WanCopyRegionFunction();
    public static final String WAN_COPY_REGION = "wan-copy region";
    public static final String WAN_COPY_REGION__HELP = "Copy a region with a senderId via WAN replication";
    public static final String WAN_COPY_REGION__REGION = "region";
    public static final String WAN_COPY_REGION__REGION__HELP = "Region from which data will be exported.";
    public static final String WAN_COPY_REGION__SENDERID = "sender-id";
    public static final String WAN_COPY_REGION__SENDERID__HELP = "Sender Id to use to copy the region.";
    public static final String WAN_COPY_REGION__MAXRATE = "max-rate";
    public static final String WAN_COPY_REGION__MAXRATE__HELP = "Maximum rate for copying in entries per second.";
    public static final String WAN_COPY_REGION__BATCHSIZE = "batch-size";
    public static final String WAN_COPY_REGION__BATCHSIZE__HELP = "Number of entries to be copied in each batch.";
    public static final String WAN_COPY_REGION__CANCEL = "cancel";
    public static final String WAN_COPY_REGION__CANCEL__HELP = "Cancel an ongoing wan-copy region command";

    @CliAvailabilityIndicator(value={"wan-copy region"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }

    @CliCommand(value={"wan-copy region"}, help="Copy a region with a senderId via WAN replication")
    @CliMetaData(relatedTopic={"Data", "Region"})
    public ResultModel wanCopyRegion(@CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Region from which data will be exported.") String regionName, @CliOption(key={"sender-id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="Sender Id to use to copy the region.") String senderId, @CliOption(key={"max-rate"}, unspecifiedDefaultValue="0", help="Maximum rate for copying in entries per second.") long maxRate, @CliOption(key={"batch-size"}, unspecifiedDefaultValue="1000", help="Number of entries to be copied in each batch.") int batchSize, @CliOption(key={"cancel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Cancel an ongoing wan-copy region command") boolean isCancel) {
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        Object[] args = new Object[]{regionName, senderId, isCancel, maxRate, batchSize};
        ResultCollector<?, ?> resultCollector = this.executeFunction(this.wanCopyRegionFunction, (Object)args, this.getAllNormalMembers());
        List<CliFunctionResult> cliFunctionResults = this.getCliFunctionResults((List)resultCollector.getResult());
        return ResultModel.createMemberStatusResult(cliFunctionResults, false, false);
    }

    private List<CliFunctionResult> getCliFunctionResults(List<CliFunctionResult> resultsObjects) {
        ArrayList<CliFunctionResult> cliFunctionResults = new ArrayList<CliFunctionResult>();
        for (CliFunctionResult result : resultsObjects) {
            if (result instanceof FunctionInvocationTargetException) {
                CliFunctionResult errorResult = new CliFunctionResult(((FunctionInvocationTargetException)((Object)result)).getMemberId().getName(), CliFunctionResult.StatusState.ERROR, ((FunctionInvocationTargetException)((Object)result)).getMessage());
                cliFunctionResults.add(errorResult);
                continue;
            }
            cliFunctionResults.add(result);
        }
        return cliFunctionResults;
    }
}

