// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.PropagateNullable;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.ArrayType;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.BooleanType;
import org.apache.doris.nereids.types.CharType;
import org.apache.doris.nereids.types.DateTimeType;
import org.apache.doris.nereids.types.DateTimeV2Type;
import org.apache.doris.nereids.types.DateType;
import org.apache.doris.nereids.types.DateV2Type;
import org.apache.doris.nereids.types.DecimalV2Type;
import org.apache.doris.nereids.types.DoubleType;
import org.apache.doris.nereids.types.FloatType;
import org.apache.doris.nereids.types.IntegerType;
import org.apache.doris.nereids.types.LargeIntType;
import org.apache.doris.nereids.types.SmallIntType;
import org.apache.doris.nereids.types.StringType;
import org.apache.doris.nereids.types.TinyIntType;
import org.apache.doris.nereids.types.VarcharType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'topn_weighted'. This class is generated by GenerateFunction.
 */
public class TopNWeighted extends AggregateFunction
        implements ExplicitlyCastableSignature, PropagateNullable {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            // three arguments
            FunctionSignature.ret(ArrayType.of(DoubleType.INSTANCE))
                    .args(DoubleType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DecimalV2Type.CATALOG_DEFAULT))
                    .args(DecimalV2Type.CATALOG_DEFAULT, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(LargeIntType.INSTANCE))
                    .args(LargeIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(BigIntType.INSTANCE))
                    .args(BigIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(IntegerType.INSTANCE))
                    .args(IntegerType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(SmallIntType.INSTANCE))
                    .args(SmallIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(TinyIntType.INSTANCE))
                    .args(TinyIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(BooleanType.INSTANCE))
                    .args(BooleanType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(FloatType.INSTANCE))
                    .args(FloatType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateType.INSTANCE))
                    .args(DateType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateTimeType.INSTANCE))
                    .args(DateTimeType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateV2Type.INSTANCE))
                    .args(DateV2Type.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateTimeV2Type.SYSTEM_DEFAULT))
                    .args(DateTimeV2Type.SYSTEM_DEFAULT, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(StringType.INSTANCE))
                    .args(StringType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(VarcharType.SYSTEM_DEFAULT))
                    .args(VarcharType.SYSTEM_DEFAULT, BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(CharType.SYSTEM_DEFAULT))
                    .args(CharType.SYSTEM_DEFAULT, BigIntType.INSTANCE, IntegerType.INSTANCE),

            // four arguments
            FunctionSignature.ret(ArrayType.of(DoubleType.INSTANCE))
                    .args(DoubleType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT)
                    .args(DecimalV2Type.CATALOG_DEFAULT,
                            BigIntType.INSTANCE,
                            IntegerType.INSTANCE,
                            IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(LargeIntType.INSTANCE))
                    .args(LargeIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(BigIntType.INSTANCE))
                    .args(BigIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(IntegerType.INSTANCE))
                    .args(IntegerType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(SmallIntType.INSTANCE))
                    .args(SmallIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(TinyIntType.INSTANCE))
                    .args(TinyIntType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(BooleanType.INSTANCE))
                    .args(BooleanType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(FloatType.INSTANCE))
                    .args(FloatType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateType.INSTANCE))
                    .args(DateType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateTimeType.INSTANCE))
                    .args(DateTimeType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateV2Type.INSTANCE))
                    .args(DateV2Type.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT)
                    .args(DateTimeV2Type.SYSTEM_DEFAULT,
                            BigIntType.INSTANCE,
                            IntegerType.INSTANCE,
                            IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(StringType.INSTANCE))
                    .args(StringType.INSTANCE, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(VarcharType.SYSTEM_DEFAULT))
                    .args(VarcharType.SYSTEM_DEFAULT, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(CharType.SYSTEM_DEFAULT))
                    .args(CharType.SYSTEM_DEFAULT, BigIntType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE)
    );

    /**
     * constructor with 3 arguments.
     */
    public TopNWeighted(Expression arg0, Expression arg1, Expression arg2) {
        super("topn_weighted", arg0, arg1, arg2);
    }

    /**
     * constructor with 3 arguments.
     */
    public TopNWeighted(boolean distinct, Expression arg0, Expression arg1, Expression arg2) {
        super("topn_weighted", distinct, arg0, arg1, arg2);
    }

    /**
     * constructor with 4 arguments.
     */
    public TopNWeighted(Expression arg0, Expression arg1, Expression arg2, Expression arg3) {
        super("topn_weighted", arg0, arg1, arg2, arg3);
    }

    /**
     * constructor with 4 arguments.
     */
    public TopNWeighted(boolean distinct, Expression arg0, Expression arg1, Expression arg2, Expression arg3) {
        super("topn_weighted", distinct, arg0, arg1, arg2, arg3);
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public TopNWeighted withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() == 3
                || children.size() == 4);
        if (children.size() == 3) {
            return new TopNWeighted(distinct, children.get(0), children.get(1), children.get(2));
        } else {
            return new TopNWeighted(distinct, children.get(0), children.get(1), children.get(2), children.get(3));
        }
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTopNWeighted(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
