/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.reconciler;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;

class LdifAnnotationUpdater {
    private static final String ERROR_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.error";
    private ILdifEditor editor;

    public LdifAnnotationUpdater(ILdifEditor editor) {
        this.editor = editor;
    }

    public void dispose() {
    }

    public void updateAnnotations(LdifContainer[] containers) {
    }

    public void updateAnnotations() {
        LdifFile model = this.editor.getLdifModel();
        ISourceViewer viewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        IAnnotationModel annotationModel = viewer.getAnnotationModel();
        if (document == null || annotationModel == null || model == null) {
            return;
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).removeAllAnnotations();
            ArrayList<Position> positionList = new ArrayList<Position>();
            List containers = model.getContainers();
            for (LdifContainer ldifContainer : containers) {
                LdifPart[] parts;
                int errorOffset = -1;
                int errorLength = -1;
                StringBuilder errorText = null;
                LdifPart[] ldifPartArray = parts = ldifContainer.getParts();
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    LdifPart ldifPart = ldifPartArray[n2];
                    if (!ldifPart.isValid()) {
                        if (errorOffset == -1) {
                            errorOffset = ldifPart.getOffset();
                            errorLength = ldifPart.getLength();
                            errorText = new StringBuilder();
                            errorText.append(ldifPart.toRawString());
                        } else {
                            errorLength += ldifPart.getLength();
                            errorText.append(ldifPart.toRawString());
                        }
                    }
                    ++n2;
                }
                if (errorOffset == -1 && !ldifContainer.isValid()) {
                    errorOffset = ldifContainer.getOffset();
                    errorLength = ldifContainer.getLength();
                    errorText = new StringBuilder();
                    errorText.append(ldifContainer.toRawString());
                }
                if (errorOffset <= -1) continue;
                Annotation annotation = new Annotation(ERROR_ANNOTATION_TYPE, true, errorText.toString());
                Position position = new Position(errorOffset, errorLength);
                positionList.add(position);
                viewer.getAnnotationModel().addAnnotation(annotation, position);
            }
        }
    }
}

