/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ImportDsmlRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportDsmlMainWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ImportDsmlWizard
extends Wizard
implements IImportWizard {
    private IBrowserConnection importConnection;
    private ImportDsmlMainWizardPage mainPage;
    private String dsmlFilename;
    private String responseFilename;
    private boolean saveResponse;

    public ImportDsmlWizard() {
        this.setWindowTitle(Messages.getString("ImportDsmlWizard.DSMLImport"));
    }

    public ImportDsmlWizard(IBrowserConnection selectedConnection) {
        this.setWindowTitle(Messages.getString("ImportDsmlWizard.DSMLImport"));
        this.importConnection = selectedConnection;
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_IMPORT_DSML;
    }

    public boolean performFinish() {
        this.mainPage.saveDialogSettings();
        if (this.dsmlFilename != null && !"".equals(this.dsmlFilename)) {
            File dsmlFile = new File(this.dsmlFilename);
            if (this.saveResponse) {
                File responseFile = new File(this.responseFilename);
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ImportDsmlRunnable(this.importConnection, dsmlFile, responseFile)}).execute();
            } else {
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ImportDsmlRunnable(this.importConnection, dsmlFile)}).execute();
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        this.importConnection = o instanceof IEntry ? ((IEntry)o).getBrowserConnection() : (o instanceof ISearchResult ? ((ISearchResult)o).getEntry().getBrowserConnection() : (o instanceof IBookmark ? ((IBookmark)o).getBrowserConnection() : (o instanceof IAttribute ? ((IAttribute)o).getEntry().getBrowserConnection() : (o instanceof IValue ? ((IValue)o).getAttribute().getEntry().getBrowserConnection() : (o instanceof IBrowserConnection ? (IBrowserConnection)o : (o instanceof Connection ? BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection((Connection)o) : (o instanceof BrowserCategory ? ((BrowserCategory)o).getParent() : null)))))));
    }

    public void addPages() {
        this.mainPage = new ImportDsmlMainWizardPage(ImportDsmlMainWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.mainPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_dsmlimport_wizard");
    }

    public IBrowserConnection getImportConnection() {
        return this.importConnection;
    }

    public void setImportConnection(IBrowserConnection connection) {
        this.importConnection = connection;
    }

    public void setDsmlFilename(String dsmlFilename) {
        this.dsmlFilename = dsmlFilename;
    }

    public void setResponseFilename(String saveFilename) {
        this.responseFilename = saveFilename;
    }

    public void setSaveResponse(boolean b) {
        this.saveResponse = b;
    }
}

