/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectDoublesSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch.update(Double.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getRank(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0, 1.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF(new double[]{0.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF(new double[0]);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch.update(1.0);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch.update(1.0);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch.update(1.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((double)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new double[]{500000.0});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((double)sketch.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch.getMaxItem(), (double)999999.0);
        double[] ranks = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            ranks[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = ranks[i2];
        }
        double[] quantiles = sketch.getQuantiles(ranks);
        double[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        double previousQuantile = 0.0;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            double quantile = sketch.getQuantile(ranks[i3]);
            Assert.assertEquals((double)quantile, (double)quantiles[i3]);
            Assert.assertEquals((double)quantile, (double)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        int n = 1000;
        double[] values = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        KllDoublesSketch sketch2 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i * 1.0);
            sketch2.update((double)(20000 - i - 1) * 1.0);
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(256, 0);
        KllDoublesSketch sketch2 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)(20000 - i - 1));
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(256, 0);
        KllDoublesSketch sketch2 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(256, 0);
        KllDoublesSketch sketch2 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        sketch2.update(1.0);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        KllDoublesSketch sketch2 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch1.update(1.0);
        sketch2.update(2.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        KllDoublesSketch sketch2 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        int n = 1000000;
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((double)i);
        }
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1000000.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(7, 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(65536, 0);
    }

    @Test
    public void minK() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(8, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(65535, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmptyViaCompactHeapify() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)sketch1.currentSerializedSizeBytes(false));
    }

    @Test
    public void serializeDeserializeEmptyViaUpdatableWritableWrap() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllDoublesSketch sketch2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        try {
            sketch2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)sketch1.currentSerializedSizeBytes(true));
    }

    @Test
    public void serializeDeserializeOneValueViaCompactHeapify() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch1.update(1.0);
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((boolean)Double.isFinite(sketch2.getMinItem()));
        Assert.assertTrue((boolean)Double.isFinite(sketch2.getMaxItem()));
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)16);
    }

    @Test
    public void serializeDeserializeOneValueViaUpdatableWritableWrap() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch1.update(1.0);
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllDoublesSketch sketch2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1.0);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)16);
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)bytes.length);
    }

    @Test
    public void serializeDeserializeFullViaCompactHeapify() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 1000);
        byte[] byteArr1 = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(byteArr1));
        Assert.assertEquals((int)byteArr1.length, (int)sketch1.currentSerializedSizeBytes(false));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch2.getMinItem(), (double)sketch1.getMinItem());
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(false), (int)sketch1.currentSerializedSizeBytes(false));
    }

    @Test
    public void serializeDeserializeFullViaUpdatableWritableWrap() {
        KllDoublesSketch sketch1 = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        byte[] bytes = KllHelper.toByteArray((KllSketch)sketch1, (boolean)true);
        KllDoublesSketch sketch2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.currentSerializedSizeBytes(true));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch2.getMinItem(), (double)sketch1.getMinItem());
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)sketch1.getMaxItem());
        Assert.assertEquals((int)sketch2.currentSerializedSizeBytes(true), (int)sketch1.currentSerializedSizeBytes(true));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch.update(0.0);
        sketch.getCDF(new double[]{1.0, 0.0});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 0);
        sketch.update(0.0);
        sketch.getCDF(new double[]{Double.NaN});
    }

    @Test
    public void checkSimpleMergeDirect() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 43;
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        for (i = 1; i <= 21; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= 43; ++i) {
            sk2.update((double)(i + 100));
        }
        KllDirectDoublesSketchTest.println("SK1:");
        KllDirectDoublesSketchTest.println(sk1.toString(true, true));
        KllDirectDoublesSketchTest.println("SK2:");
        KllDirectDoublesSketchTest.println(sk2.toString(true, true));
        MemorySegment wseg1 = MemorySegment.ofArray(KllHelper.toByteArray((KllSketch)sk1, (boolean)true));
        MemorySegment wseg2 = MemorySegment.ofArray(KllHelper.toByteArray((KllSketch)sk2, (boolean)true));
        KllDoublesSketch dsk1 = KllDoublesSketch.wrap((MemorySegment)wseg1);
        KllDoublesSketch dsk2 = KllDoublesSketch.wrap((MemorySegment)wseg2);
        KllDirectDoublesSketchTest.println("BEFORE MERGE");
        KllDirectDoublesSketchTest.println(dsk1.toString(true, true));
        dsk1.merge((KllSketch)dsk2);
        KllDirectDoublesSketchTest.println("AFTER MERGE");
        KllDirectDoublesSketchTest.println(dsk1.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDirectDoubleUpdatableMemorySegment() {
        int k = 20;
        KllDirectDoublesSketchTest.println("#### CASE: DOUBLE FULL DIRECT FROM UPDATABLE");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        KllDirectDoublesSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true));
        KllDoublesSketch sk = KllDoublesSketch.wrap((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.levelsArr.length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectDoublesSketchTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)20);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        KllDirectDoublesSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true));
        sk = KllDoublesSketch.wrap((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.levelsArr.length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectDoublesSketchTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)20);
        sk2.update(1.0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        KllDirectDoublesSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true));
        sk = KllDoublesSketch.wrap((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.levelsArr.length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkGetMemorySegment() {
        KllDoublesSketch sketch = KllDirectDoublesSketchTest.getUpdatableDirectDoublesSketch(200, 200);
        Assert.assertEquals((int)sketch.getK(), (int)200);
        Assert.assertEquals((long)sketch.getN(), (long)200L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isMemorySegmentUpdatableFormat());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertTrue((boolean)sketch.isKllDoublesSketch());
        Assert.assertFalse((boolean)sketch.isLevelZeroSorted());
        Assert.assertFalse((boolean)sketch.isKllFloatsSketch());
        MemorySegment wseg = sketch.getMemorySegment();
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)200);
        Assert.assertEquals((long)sk.getN(), (long)200L);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isMemorySegmentUpdatableFormat());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertTrue((boolean)sk.isKllDoublesSketch());
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        Assert.assertFalse((boolean)sk.isKllFloatsSketch());
    }

    @Test
    public void checkReset() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n1 = sk.getN();
        double min1 = sk.getMinItem();
        double max1 = sk.getMaxItem();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n2 = sk.getN();
        double min2 = sk.getMinItem();
        double max2 = sk.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((double)min2, (double)min1);
        Assert.assertEquals((double)max2, (double)max1);
    }

    @Test
    public void checkHeapify() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        KllHeapDoublesSketch sk2 = KllHeapDoublesSketch.heapifyImpl((MemorySegment)dstSeg);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)100.0);
    }

    @Test
    public void checkMergeKllDoublesSketch() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)(i + 100));
        }
        sk.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)121.0);
    }

    @Test
    public void checkReverseMergeKllDoubleSketch() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)(i + 100));
        }
        sk2.merge((KllSketch)sk);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)121.0);
    }

    @Test
    public void checkWritableWrapOfCompactForm() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        MemorySegment srcSeg = MemorySegment.ofArray(sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)srcSeg);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)21.0);
    }

    @Test
    public void checkReadOnlyExceptions() {
        int k = 20;
        double[] dblArr = new double[]{};
        double dblV = 1.0;
        boolean idx = true;
        boolean bool = true;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        try {
            sk2.incN(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.incNumLevels();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setDoubleItemsArray(dblArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setDoubleItemsArrayAt(1, 1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelZeroSorted(true);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMaxItem(1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinItem(1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinK(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setN(1L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setNumLevels(1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMergeExceptions() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        MemorySegment srcSeg1 = MemorySegment.ofArray(sk1.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)srcSeg1);
        sk2.merge((KllSketch)sk1);
    }

    @Test
    public void checkVectorUpdate() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)20, (MemorySegment)dstSeg, null);
        double[] v = new double[21];
        for (int i = 0; i < 21; ++i) {
            v[i] = i + 1;
        }
        sk.update(v, 0, 21);
        KllDirectDoublesSketchTest.println(sk.toString(true, true));
        int[] levelsArr = sk.getLevelsArray(KllSketch.SketchStructure.UPDATABLE);
        Assert.assertEquals((int)levelsArr[0], (int)22);
        double[] doublesArr = sk.getDoubleItemsArray();
        Assert.assertEquals((double)doublesArr[22], (double)21.0);
    }

    @Test
    public void checkWeightedUpdate() {
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)8, (MemorySegment)dstSeg, null);
        for (int i = 0; i < 16; ++i) {
            sk.update((double)(i + 1), 16L);
        }
        KllDirectDoublesSketchTest.println(sk.toString(true, true));
        Assert.assertEquals((long)sk.getN(), (long)256L);
        Assert.assertEquals((double)sk.getMaxItem(), (double)16.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
    }

    private static KllDoublesSketch getUpdatableDirectDoublesSketch(int k, int n) {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        return KllDoublesSketch.wrap((MemorySegment)wseg);
    }

    @Test
    public void checkMergeExceptionsWrongType() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        try {
            sk1.merge((KllSketch)sk2);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            sk2.merge((KllSketch)sk1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static final void println(Object o) {
    }
}

