/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardSimilarity;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JaccardSimilarityTest {
    private static JaccardSimilarity classBeingTested;

    JaccardSimilarityTest() {
    }

    @BeforeAll
    public static void setUp() {
        classBeingTested = new JaccardSimilarity();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputsEquals()"})
    void testGettingJaccardSimilarity(Class<?> cls) {
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "left"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "right")));
        Assertions.assertEquals((double)0.75, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")));
        Assertions.assertEquals((double)0.2222222222222222, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((double)0.6363636363636364, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "ABC Corporation"), SimilarityInputTest.build(cls, "ABC Corp")));
        Assertions.assertEquals((double)0.7647058823529411, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "D N H Enterprises Inc"), SimilarityInputTest.build(cls, "D & H Enterprises, Inc.")));
        Assertions.assertEquals((double)0.8888888888888888, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "My Gym Children's Fitness Center"), SimilarityInputTest.build(cls, "My Gym. Childrens Fitness")));
        Assertions.assertEquals((double)0.9, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "PENNSYLVANIA"), SimilarityInputTest.build(cls, "PENNCISYLVNIA")));
        Assertions.assertEquals((double)0.125, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "left"), SimilarityInputTest.build(cls, "right")));
        Assertions.assertEquals((double)0.125, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "leettteft"), SimilarityInputTest.build(cls, "ritttght")));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "the same string"), SimilarityInputTest.build(cls, "the same string")));
    }

    @Test
    void testGettingJaccardSimilarityCharSequence() {
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)""));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"));
        Assertions.assertEquals((double)0.75, (Double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((double)0.2222222222222222, (Double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((double)0.6363636363636364, (Double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((double)0.7647058823529411, (Double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((double)0.8888888888888888, (Double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((double)0.9, (Double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((double)0.125, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"));
        Assertions.assertEquals((double)0.125, (Double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    void testGettingJaccardSimilarityNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> classBeingTested.apply((CharSequence)null, null));
    }

    @Test
    void testGettingJaccardSimilarityNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> classBeingTested.apply(null, (CharSequence)"right"));
    }

    @Test
    void testGettingJaccardSimilarityStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> classBeingTested.apply((CharSequence)" ", null));
    }
}

